package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * 操作目标.
 *
 * @author dongbin
 * @version 0.1 2023/5/9 17:24
 * @since 1.8
 */
public enum TaskOperationTarget {

    /**
     * 未知.表示失败.
     */
    UNKNOWN(0),

    /**
     * 二开服务包.
     */
    CUSTOMIZATION_SERVICE_PACKAGE(1),

    /**
     * 租户服务包关联.
     */
    TENANT_SERVICE_PACKAGE(2),

    /**
     * 二开服务包和功能集的关联.
     */
    CUSTOMIZATION_SERVICE_PACKAGE_RESOURCE_SET(3),

    /**
     * 功能集.
     */
    RESOURCE_SET(4),

    /**
     * 功能集和资源码的关系.
     */
    RESOURCE_SET_RESOURCE_CODE(5),

    /**
     * 资源码.
     */
    RESOURCE_CODE(6),

    /**
     * 角色.
     */
    ROLE(7),

    /**
     * 角色和功能集的关系.
     */
    ROLE_RESOURCE_SET(8),

    /**
     * 用户.
     */
    USER(9),

    /**
     * 帐号.
     */
    ACCOUNT(10),

    /**
     * 组织.
     */
    ORGANIZATION(11),

    /**
     * 公司.
     */
    COMPANY(12),

    /**
     * 自定义组织类型.
     */
    CUSTOMIZE_ORGANIZATION_TYPE(13),

    /**
     * 租户公司关联表.
     */
    TENANT_COMPANY(14),

    /**
     * 用户和角色的关系.
     */
    USER_ROLE_REL(15),

    /**
     * 用户和组织的关系.
     */
    USER_ORG_REL(16),

    /**
     * 用户标签.
     */
    USER_TAG(17),

    /**
     * 此为一个特殊的目标, 用以操作当前任务的状态.
     */
    OPERATION_TASK_STATUS(18),

    /**
     * 此为一个特殊的目标,用以操作scheme的计划完成的时间.
     */
    TARGET_EXECTUION_END_TIME(19);

    private final int value;

    TaskOperationTarget(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static TaskOperationTarget valueOf(int value) {
        return Stream.of(TaskOperationTarget.values())
            .filter(v -> v.value() == value)
            .findFirst()
            .orElse(UNKNOWN);
    }
}
