package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * operation的操作类型.
 *
 * @author dongbin
 * @version 0.1 2023/5/12 13:48
 * @since 1.8
 */
public enum TaskOperationType {
    /**
     * 未知,表示一个错误.
     */
    UNKNOWN(0),

    /**
     * 保存.
     */
    SAVE(1),

    /**
     * 删除.
     */
    DELETE(2);

    private final int value;

    TaskOperationType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static TaskOperationType valueOf(int value) {
        return Stream.of(TaskOperationType.values())
                .filter(v -> v.value() == value)
                .findFirst()
                .orElse(UNKNOWN);
    }
}
