package com.xforceplus.enums.cloudshell;

import java.util.stream.Stream;

/**
 * 任务状态.
 *
 * @author dongbin
 * @version 0.1 2023/5/9 17:21
 * @since 1.8
 */
public enum TaskStatus {

    /**
     * 未知状态.
     */
    UNKNOWN(0),

    /**
     * 任务预创建, 表示任务方案正在设计中.(此状态的任务不会被调度)
     */
    PRECREATE(1),

    /**
     * 任务已经创建,等待调度.
     */
    CREATED(2),

    /**
     * 任务已经调度完成开始执行.
     */
    EXECUTING(3),

    /**
     * 任务已经被命令取消,正在等待调度.
     */
    CANCELLING(4),

    /**
     * 任务已经成功取消.
     */
    CANCELLED(5),

    /**
     * 功能服务同步完成.
     */
    FUNCTION_COMPLETE(6),

    /**
     * 任务完成,最终状态.
     */
    FINISHED(7),

    /**
     * 任务失败, 最终状态.
     */
    FAILURE(8);

    private final int value;

    TaskStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TaskStatus valueOf(int value) {
        return Stream.of(TaskStatus.values())
                .filter(target -> target.getValue() == value)
                .findFirst()
                .orElse(TaskStatus.UNKNOWN);
    }
}
