package com.xforceplus.enums.cloudshell.extra;

import java.util.stream.Stream;

/**
 * cloudshlle方案扩展信息中的用户帐号状态.
 *
 * @author dongbin
 * @version 0.1 2023/5/23 16:15
 * @since 1.8
 */
public enum UserAccountTemporaryStatus {

    /**
     * 未知,表示错误.
     */
    UNKNOWN(0),

    /**
     * 排除.
     */
    EXCLUSION(1),

    /**
     * 包含.
     */
    INCLUSION(2),

    /**
     * 冲突.
     */
    CONFLICT(3),

    /**
     * 表示任何状态.
     */
    ANY(4);

    private final int value;

    UserAccountTemporaryStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static UserAccountTemporaryStatus valueOf(int value) {
        return Stream.of(UserAccountTemporaryStatus.values())
                .filter(target -> target.getValue() == value)
                .findFirst()
                .orElse(UserAccountTemporaryStatus.UNKNOWN);
    }
}
