/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.cloudshell;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.StringJoiner;

@Schema(name="sse\u6d88\u606f\u901a\u77e5")
public class SseNotification {
    public static final String PROGRESS_CHANGE_TYPE = "progressChange";
    public static final String FINISHED_TYPE = "progressFinished";
    public static final String ERROR_FINISHED_TYPE = "progressError";
    @Schema(description="\u901a\u77e5\u7c7b\u578b.", allowableValues={"progressChange", "progressFinished"}, format="string")
    private final String type;
    @Schema(description="\u8fdb\u5ea6\u503c, \u5f53type=progressChange\u65f6\u624d\u6709\u6548.", minimum="0", maximum="1.0", format="float")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Float progress;
    @Schema(description="\u8fdb\u5ea6\u7ed3\u675f\u540e\u7684\u503c, \u5f53type=progressFinished\u65f6\u624d\u6709\u6548.", format="json")
    @JsonRawValue
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String info;
    @Schema(description="\u9519\u8bef\u4fe1\u606f, \u5f53type=progressError\u65f6\u624d\u6709\u6548.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String cause;

    public static SseNotification buildProgressChange(float progress) {
        return new SseNotification(progress);
    }

    public static SseNotification buildFinished(String value) {
        return new SseNotification(value);
    }

    public static SseNotification buildError(Throwable throwable) {
        return new SseNotification(throwable);
    }

    private SseNotification(float progress) {
        this.type = PROGRESS_CHANGE_TYPE;
        this.progress = Float.valueOf(progress);
        this.info = null;
        this.cause = null;
    }

    private SseNotification(String info) {
        this.type = FINISHED_TYPE;
        this.progress = null;
        this.info = info == null ? "{}" : info;
        this.cause = null;
    }

    private SseNotification(Throwable throwable) {
        this.type = ERROR_FINISHED_TYPE;
        this.progress = null;
        this.info = null;
        this.cause = throwable == null ? "Unknown Error!" : throwable.getMessage();
    }

    public String getType() {
        return this.type;
    }

    public Float getProgress() {
        return this.progress;
    }

    public Object getInfo() {
        return this.info;
    }

    public String getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SseNotification)) {
            return false;
        }
        SseNotification that = (SseNotification)o;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getProgress(), that.getProgress()) && Objects.equals(this.getInfo(), that.getInfo()) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getProgress(), this.getInfo(), this.cause);
    }

    public String toString() {
        return new StringJoiner(", ", SseNotification.class.getSimpleName() + "[", "]").add("cause='" + this.cause + "'").add("info='" + this.info + "'").add("progress=" + this.progress).add("type='" + this.type + "'").toString();
    }
}

