/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.company;

import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.enums.Value;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum Switch implements Value<Integer>
{
    INVOICE,
    STATEMENT,
    TAX_TERMINAL_DEVICE;


    public Integer value() {
        return BinaryUtils.toBinary((Enum)this);
    }

    public static int toValue(Collection<Integer> values) {
        if (values == null || values.isEmpty()) {
            return 0;
        }
        int allTrue = BinaryUtils.allTrue(Switch.class);
        int switches = 0;
        for (int switchValue : values) {
            switches |= (switchValue &= allTrue);
        }
        return switches;
    }

    public static int toValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        String[] splittedValues = StringUtils.split((String)value, (String)",");
        int allTrue = BinaryUtils.allTrue(Switch.class);
        int switches = 0;
        for (String splittedValue : splittedValues) {
            try {
                int switchValue = Integer.parseInt(splittedValue);
                switches |= (switchValue &= allTrue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return switches;
    }

    public static List<Integer> toValues(int value) {
        List values = BinaryUtils.fromBinaryToValues((int)value, Switch.class);
        return values;
    }

    public static int allTrue() {
        return BinaryUtils.allTrue(Switch.class);
    }
}

