/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.enums.EnumMapUtils;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="\u7ec4\u7ec7Dto")
public class OrgDto<O extends OrgDto<O>>
extends Org<O>
implements IOperator {
    @JsonView(value={View.class, RedisView.class})
    protected String orgDesc;
    @JsonView(value={View.class, RedisView.class})
    protected String orgBizType;
    @JsonView(value={View.List.class, RedisView.class})
    protected String tenantName;
    @JsonView(value={View.List.class, RedisView.class})
    protected String tenantCode;
    @JsonView(value={View.class, RedisView.class})
    protected String parentName;
    @JsonView(value={View.class, RedisView.class})
    protected String parentCode;
    @JsonView(value={View.class, RedisView.class})
    protected Integer relatedSwitches;
    @JsonView(value={View.class, RedisView.class})
    protected Integer status;
    @JsonView(value={View.class, RedisView.class})
    protected Integer auditStatus;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date enabledTime;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date disabledTime;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date createTime;
    @JsonView(value={View.class, RedisView.class})
    protected String createrId;
    @JsonView(value={View.class, RedisView.class})
    protected String createrName;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterId;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterName;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date updateTime;
    @JsonView(value={View.class})
    protected Long userCount;
    @JsonView(value={View.class})
    protected Long childrenCount;
    @JsonView(value={View.class, RedisView.class})
    protected Boolean userBound;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={View.class, RedisView.class})
    protected Set<String> companyNos;
    @ArraySchema(schema=@Schema(implementation=OrgExtensionDto.class))
    @JsonView(value={View.class, RedisView.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Set<OrgExtensionDto> extensions;
    @ArraySchema(schema=@Schema(implementation=OrgDto.class))
    @JsonView(value={View.class, RedisView.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<O> parentOrgs;
    @ArraySchema(schema=@Schema(implementation=OrgDto.class))
    @JsonView(value={View.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<O> descendants;
    @ArraySchema(schema=@Schema(implementation=OrgDto.class))
    @JsonView(value={View.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<O> ancestors;
    @JsonView(value={View.List.class, View.Tree.class, RedisView.class})
    protected String orgTypeCode;
    @JsonView(value={View.List.class, View.Tree.class, RedisView.class})
    protected String orgTypeName;
    @JsonView(value={View.Tree.class, View.List.class})
    protected Boolean isOrgAdmin;
    @JsonView(value={View.Tree.class, View.List.class})
    protected Boolean checked;
    @ArraySchema(schema=@Schema(implementation=UserDto.class))
    @JsonView(value={View.List.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected List<UserDto> orgUsers;
    @JsonIgnore
    protected Boolean ignoreRebuildParentIdsListener;
    @JsonIgnore
    protected Boolean ignoreChangeValidListener;
    @JsonIgnore
    protected Boolean ignoreChangeCacheListener;

    @JsonView(value={View.class, RedisView.class})
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getOrgId() {
        return (Long)this.id;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getTenantId() {
        return this.tenantId;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getCompanyId() {
        return this.companyId;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getParentId() {
        return (Long)this.parentId;
    }

    @JsonView(value={View.class, RedisView.class})
    public String getTaxNum() {
        return this.taxNum;
    }

    @JsonView(value={View.class, RedisView.class})
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonView(value={View.List.class, RedisView.class})
    public String getCompanyCode() {
        return this.companyCode;
    }

    @JsonView(value={View.Tree.class, View.List.class})
    public Integer getUserOrgType() {
        return this.sign;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={View.List.class})
    public Map<Switch, Boolean> getRelatedSwitchesMap() {
        if (this.relatedSwitches == null) {
            return Collections.emptyMap();
        }
        return EnumMapUtils.toEnumMap(Switch.class, (int)this.relatedSwitches);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgDto)) {
            return false;
        }
        OrgDto that = (OrgDto)((Object)o);
        return Objects.equals(this.id, that.id) || Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.orgCode, that.orgCode);
    }

    public int hashCode() {
        if (this.id != null && (Long)this.id > 0L) {
            return Objects.hash(this.id);
        }
        return Objects.hash(this.tenantId, this.orgCode);
    }

    public String toString() {
        return "OrgDto{orgCode=" + this.orgCode + ", orgName=" + this.orgName + ", tenantId=" + this.tenantId + ", companyId=" + this.companyId + ", orgType=" + this.orgType + ", taxNum=" + this.taxNum + ", id=" + this.id + ", parentId=" + this.parentId + ", parentIds=" + this.parentIds + '}';
    }

    @JsonView(value={View.class, RedisView.class})
    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setOrgBizType(String orgBizType) {
        this.orgBizType = orgBizType;
    }

    @JsonView(value={View.List.class, RedisView.class})
    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    @JsonView(value={View.List.class, RedisView.class})
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setRelatedSwitches(Integer relatedSwitches) {
        this.relatedSwitches = relatedSwitches;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setEnabledTime(Date enabledTime) {
        this.enabledTime = enabledTime;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setDisabledTime(Date disabledTime) {
        this.disabledTime = disabledTime;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonView(value={View.class})
    public void setUserCount(Long userCount) {
        this.userCount = userCount;
    }

    @JsonView(value={View.class})
    public void setChildrenCount(Long childrenCount) {
        this.childrenCount = childrenCount;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserBound(Boolean userBound) {
        this.userBound = userBound;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCompanyNos(Set<String> companyNos) {
        this.companyNos = companyNos;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setExtensions(Set<OrgExtensionDto> extensions) {
        this.extensions = extensions;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setParentOrgs(List<O> parentOrgs) {
        this.parentOrgs = parentOrgs;
    }

    @JsonView(value={View.class})
    public void setDescendants(List<O> descendants) {
        this.descendants = descendants;
    }

    @JsonView(value={View.class})
    public void setAncestors(List<O> ancestors) {
        this.ancestors = ancestors;
    }

    @JsonView(value={View.List.class, View.Tree.class, RedisView.class})
    public void setOrgTypeCode(String orgTypeCode) {
        this.orgTypeCode = orgTypeCode;
    }

    @JsonView(value={View.List.class, View.Tree.class, RedisView.class})
    public void setOrgTypeName(String orgTypeName) {
        this.orgTypeName = orgTypeName;
    }

    @JsonView(value={View.Tree.class, View.List.class})
    public void setIsOrgAdmin(Boolean isOrgAdmin) {
        this.isOrgAdmin = isOrgAdmin;
    }

    @JsonView(value={View.Tree.class, View.List.class})
    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    @JsonView(value={View.List.class})
    public void setOrgUsers(List<UserDto> orgUsers) {
        this.orgUsers = orgUsers;
    }

    @JsonIgnore
    public void setIgnoreRebuildParentIdsListener(Boolean ignoreRebuildParentIdsListener) {
        this.ignoreRebuildParentIdsListener = ignoreRebuildParentIdsListener;
    }

    @JsonIgnore
    public void setIgnoreChangeValidListener(Boolean ignoreChangeValidListener) {
        this.ignoreChangeValidListener = ignoreChangeValidListener;
    }

    @JsonIgnore
    public void setIgnoreChangeCacheListener(Boolean ignoreChangeCacheListener) {
        this.ignoreChangeCacheListener = ignoreChangeCacheListener;
    }

    public String getOrgDesc() {
        return this.orgDesc;
    }

    public String getOrgBizType() {
        return this.orgBizType;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public Integer getRelatedSwitches() {
        return this.relatedSwitches;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    public Date getEnabledTime() {
        return this.enabledTime;
    }

    public Date getDisabledTime() {
        return this.disabledTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Long getUserCount() {
        return this.userCount;
    }

    public Long getChildrenCount() {
        return this.childrenCount;
    }

    public Boolean getUserBound() {
        return this.userBound;
    }

    public Set<String> getCompanyNos() {
        return this.companyNos;
    }

    public Set<OrgExtensionDto> getExtensions() {
        return this.extensions;
    }

    public List<O> getParentOrgs() {
        return this.parentOrgs;
    }

    public List<O> getDescendants() {
        return this.descendants;
    }

    public List<O> getAncestors() {
        return this.ancestors;
    }

    public String getOrgTypeCode() {
        return this.orgTypeCode;
    }

    public String getOrgTypeName() {
        return this.orgTypeName;
    }

    public Boolean getIsOrgAdmin() {
        return this.isOrgAdmin;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public List<UserDto> getOrgUsers() {
        return this.orgUsers;
    }

    public Boolean getIgnoreRebuildParentIdsListener() {
        return this.ignoreRebuildParentIdsListener;
    }

    public Boolean getIgnoreChangeValidListener() {
        return this.ignoreChangeValidListener;
    }

    public Boolean getIgnoreChangeCacheListener() {
        return this.ignoreChangeCacheListener;
    }

    public static final class Fields {
        public static final String orgDesc = "orgDesc";
        public static final String orgBizType = "orgBizType";
        public static final String tenantName = "tenantName";
        public static final String tenantCode = "tenantCode";
        public static final String parentName = "parentName";
        public static final String parentCode = "parentCode";
        public static final String relatedSwitches = "relatedSwitches";
        public static final String status = "status";
        public static final String auditStatus = "auditStatus";
        public static final String enabledTime = "enabledTime";
        public static final String disabledTime = "disabledTime";
        public static final String createTime = "createTime";
        public static final String createrId = "createrId";
        public static final String createrName = "createrName";
        public static final String updaterId = "updaterId";
        public static final String updaterName = "updaterName";
        public static final String updateTime = "updateTime";
        public static final String userCount = "userCount";
        public static final String childrenCount = "childrenCount";
        public static final String userBound = "userBound";
        public static final String companyNos = "companyNos";
        public static final String extensions = "extensions";
        public static final String parentOrgs = "parentOrgs";
        public static final String descendants = "descendants";
        public static final String ancestors = "ancestors";
        public static final String orgTypeCode = "orgTypeCode";
        public static final String orgTypeName = "orgTypeName";
        public static final String isOrgAdmin = "isOrgAdmin";
        public static final String checked = "checked";
        public static final String orgUsers = "orgUsers";
        public static final String ignoreRebuildParentIdsListener = "ignoreRebuildParentIdsListener";
        public static final String ignoreChangeValidListener = "ignoreChangeValidListener";
        public static final String ignoreChangeCacheListener = "ignoreChangeCacheListener";

        private Fields() {
        }
    }
}

