/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.resource.view.ServicePackageView;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Range;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="\u670d\u52a1\u5305Dto")
public class ServicePackageDto
implements IOperator {
    @ArraySchema(schema=@Schema(implementation=ResourcesetDto.class))
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    protected Set<ResourcesetDto> resourcesets;
    @JsonView(value={View.class, RedisView.class})
    protected Long servicePackageId;
    @JsonView(value={View.class, RedisView.class})
    @Min(value=1L)
    @NotNull(groups={ValidationGroup.OnCreate.class})
    protected @Min(value=1L) @NotNull(groups={ValidationGroup.OnCreate.class}) Long appId;
    @JsonView(value={View.class})
    protected String appName;
    @JsonView(value={View.class, RedisView.class})
    @Pattern(regexp="\\s*|[a-zA-Z\\d_\\-]+", groups={ValidationGroup.OnCreate.class, ValidationGroup.OnUpdate.class}, message="\u4ee3\u7801\u4e0d\u80fd\u6709\u6c49\u5b57")
    protected @Pattern(regexp="\\s*|[a-zA-Z\\d_\\-]+", groups={ValidationGroup.OnCreate.class, ValidationGroup.OnUpdate.class}, message="\u4ee3\u7801\u4e0d\u80fd\u6709\u6c49\u5b57") String servicePackageCode;
    @JsonView(value={View.class, RedisView.class})
    @NotEmpty(groups={ValidationGroup.OnCreate.class})
    protected String servicePackageName;
    @JsonView(value={View.class, RedisView.class})
    @NotNull(groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011")
    @Min(value=1L, groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011")
    @Max(value=2L, groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011")
    protected @NotNull(groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011") @Min(value=1L, groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011") @Max(value=2L, groups={ValidationGroup.OnCreate.class}, message="\u4e0d\u5408\u6cd5\u7684\u503c,\u8303\u56f4\u30101:\u6807\u51c6,2:\u4e8c\u5f00\u3011") Integer type;
    @JsonView(value={View.class, RedisView.class})
    protected String servicePackageDesc;
    @JsonView(value={View.class, RedisView.class})
    @Range(max=1L, min=0L)
    protected @Range(max=1L, min=0L) Integer status;
    @JsonView(value={View.class, RedisView.class})
    protected String createrId;
    @JsonView(value={View.class, RedisView.class})
    protected String createrName;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date createTime;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterId;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterName;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date updateTime;

    public ServicePackageDto() {
    }

    public ServicePackageDto(Long servicePackageId, String servicePackageName, Long appId) {
        this.servicePackageId = servicePackageId;
        this.servicePackageName = servicePackageName;
        this.appId = appId;
    }

    public ServicePackageDto(Long servicePackageId, String servicePackageCode, String servicePackageName, Long appId, Integer type) {
        this.servicePackageId = servicePackageId;
        this.servicePackageCode = servicePackageCode;
        this.servicePackageName = servicePackageName;
        this.appId = appId;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePackageDto that = (ServicePackageDto)o;
        if (this.servicePackageId != null && Objects.equals(this.servicePackageId, that.servicePackageId)) {
            return true;
        }
        return Objects.equals(this.servicePackageCode, that.servicePackageCode);
    }

    public int hashCode() {
        return Objects.hash(this.servicePackageCode);
    }

    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    public void setResourcesets(Set<ResourcesetDto> resourcesets) {
        this.resourcesets = resourcesets;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setServicePackageId(Long servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @JsonView(value={View.class})
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setServicePackageCode(String servicePackageCode) {
        this.servicePackageCode = servicePackageCode;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setType(Integer type) {
        this.type = type;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Set<ResourcesetDto> getResourcesets() {
        return this.resourcesets;
    }

    public Long getServicePackageId() {
        return this.servicePackageId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServicePackageCode() {
        return this.servicePackageCode;
    }

    public String getServicePackageName() {
        return this.servicePackageName;
    }

    public Integer getType() {
        return this.type;
    }

    public String getServicePackageDesc() {
        return this.servicePackageDesc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public static final class Fields {
        public static final String resourcesets = "resourcesets";
        public static final String servicePackageId = "servicePackageId";
        public static final String appId = "appId";
        public static final String appName = "appName";
        public static final String servicePackageCode = "servicePackageCode";
        public static final String servicePackageName = "servicePackageName";
        public static final String type = "type";
        public static final String servicePackageDesc = "servicePackageDesc";
        public static final String status = "status";
        public static final String createrId = "createrId";
        public static final String createrName = "createrName";
        public static final String createTime = "createTime";
        public static final String updaterId = "updaterId";
        public static final String updaterName = "updaterName";
        public static final String updateTime = "updateTime";

        private Fields() {
        }
    }
}

