/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.tenant.TenantExtensionDto;
import com.xforceplus.domain.tenant.TenantManager;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="\u79df\u6237Dto")
public class TenantDto
implements IOperator {
    @JsonView(value={View.class, RedisView.class})
    protected Long tenantId;
    @JsonView(value={View.class, RedisView.class})
    protected String tenantName;
    @JsonView(value={View.class, RedisView.class})
    protected String tenantCode;
    @JsonView(value={View.class, RedisView.class})
    protected String tenantDesc;
    @JsonView(value={View.class, RedisView.class})
    protected String settledOrigin;
    @JsonView(value={View.class, RedisView.class})
    protected String operateReason;
    @JsonView(value={View.class, RedisView.class})
    protected String tenantLogo;
    @JsonView(value={View.class, RedisView.class})
    protected Integer status;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date createTime;
    @JsonView(value={RedisView.class})
    protected String createrId;
    @JsonView(value={RedisView.class})
    protected String createrName;
    @JsonView(value={RedisView.class})
    protected String updaterId;
    @JsonView(value={RedisView.class})
    protected String updaterName;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date updateTime;
    @JsonView(value={View.class, RedisView.class})
    protected Long companyCount;
    @ArraySchema(schema=@Schema(implementation=TenantExtensionDto.class))
    @JsonView(value={View.class})
    protected List<TenantExtensionDto> extensions;
    @ArraySchema(schema=@Schema(implementation=UserDto.class))
    @JsonView(value={View.class})
    private List<UserDto> admins;

    public List<UserDto> getAdmins() {
        return this.admins;
    }

    @JsonView(value={View.class})
    public TenantManager getTenantManager() {
        if (CollectionUtils.isEmpty(this.admins)) {
            return null;
        }
        return this.admins.stream().filter(Objects::nonNull).map(admin -> {
            if (admin.getAccount() == null) {
                return null;
            }
            TenantManager tenantManager = TenantManager.builder().userId(admin.getId()).tenantId(admin.getTenantId()).name(admin.getUserName()).account(((AccountDto)admin.getAccount()).getUsername()).emailAccount(((AccountDto)admin.getAccount()).getEmail()).phoneAccount(((AccountDto)admin.getAccount()).getTelPhone()).accountId(((AccountDto)admin.getAccount()).getAccountId()).build();
            return tenantManager;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantDto)) {
            return false;
        }
        TenantDto that = (TenantDto)o;
        return Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId);
    }

    @JsonView(value={View.class, RedisView.class})
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setTenantDesc(String tenantDesc) {
        this.tenantDesc = tenantDesc;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setSettledOrigin(String settledOrigin) {
        this.settledOrigin = settledOrigin;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setTenantLogo(String tenantLogo) {
        this.tenantLogo = tenantLogo;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonView(value={RedisView.class})
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @JsonView(value={RedisView.class})
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @JsonView(value={RedisView.class})
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @JsonView(value={RedisView.class})
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCompanyCount(Long companyCount) {
        this.companyCount = companyCount;
    }

    @JsonView(value={View.class})
    public void setExtensions(List<TenantExtensionDto> extensions) {
        this.extensions = extensions;
    }

    @JsonView(value={View.class})
    public void setAdmins(List<UserDto> admins) {
        this.admins = admins;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getTenantDesc() {
        return this.tenantDesc;
    }

    public String getSettledOrigin() {
        return this.settledOrigin;
    }

    public String getOperateReason() {
        return this.operateReason;
    }

    public String getTenantLogo() {
        return this.tenantLogo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Long getCompanyCount() {
        return this.companyCount;
    }

    public List<TenantExtensionDto> getExtensions() {
        return this.extensions;
    }

    public static final class Fields {
        public static final String tenantId = "tenantId";
        public static final String tenantName = "tenantName";
        public static final String tenantCode = "tenantCode";
        public static final String tenantDesc = "tenantDesc";
        public static final String settledOrigin = "settledOrigin";
        public static final String operateReason = "operateReason";
        public static final String tenantLogo = "tenantLogo";
        public static final String status = "status";
        public static final String createTime = "createTime";
        public static final String createrId = "createrId";
        public static final String createrName = "createrName";
        public static final String updaterId = "updaterId";
        public static final String updaterName = "updaterName";
        public static final String updateTime = "updateTime";
        public static final String companyCount = "companyCount";
        public static final String extensions = "extensions";
        public static final String admins = "admins";

        private Fields() {
        }
    }
}

