/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import com.xforceplus.tenant.security.token.domain.view.RedisView;
import com.xforceplus.utils.DateUtils;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="\u7528\u6237Dto")
public class UserDto<O extends OrgDto<O>, R extends RoleDto, A extends AccountDto>
extends AuthorizedUser<O, R>
implements IOperator {
    @JsonView(value={View.class, RedisView.class})
    protected String userNumber;
    @JsonView(value={View.class, RedisView.class})
    protected String userPhone;
    @JsonView(value={View.class, RedisView.class})
    protected Integer userSex;
    @JsonView(value={View.class, RedisView.class})
    protected String userEmailAddr;
    @JsonView(value={View.class, RedisView.class})
    protected String userIdCard;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JsonView(value={View.class, RedisView.class})
    protected Date userPeriodTime;
    @JsonView(value={View.class, RedisView.class})
    protected String userWorkTel;
    @JsonView(value={View.class, RedisView.class})
    protected Integer activeStatus;
    @JsonView(value={View.class, RedisView.class})
    protected Integer status;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date createTime;
    @JsonView(value={View.class, RedisView.class})
    protected String createrId;
    @JsonView(value={View.class, RedisView.class})
    protected String createrName;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterId;
    @JsonView(value={View.class, RedisView.class})
    protected String updaterName;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date updateTime;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    protected Date expiredDate;
    @JsonView(value={View.class, RedisView.class})
    protected String contactAddr;
    @JsonView(value={View.class, RedisView.class})
    protected String businessExtensionAttribute;
    @JsonView(value={View.class, RedisView.class})
    protected String invoiceType;
    @JsonView(value={View.class, RedisView.class})
    protected String printingEquipment;
    @JsonView(value={View.class, RedisView.class})
    protected String ticketOpeningTerminal;
    @Schema(implementation=AccountDto.class)
    @JsonView(value={View.class, RedisView.class})
    protected A account;
    protected Set<String> filterParentIdSet;
    @JsonView(value={View.class, RedisView.class})
    protected Integer sourceType;
    @JsonView(value={View.class})
    protected Integer orgRelType;
    @JsonView(value={View.Tree.class, View.List.class, RedisView.class})
    protected Boolean isOrgAdmin;
    @JsonView(value={View.Tree.class, View.List.class})
    protected Boolean hasFullOrgs;
    @JsonView(value={UserView.UserInfo.class, View.Tree.class, View.List.class})
    protected Boolean isLastTenantAdmin;
    @JsonView(value={UserView.UserInfo.class, View.Tree.class, View.List.class})
    protected Boolean isTenantAdmin;
    @JsonView(value={View.class})
    protected String accountUserName;
    @JsonView(value={View.class})
    protected String accountEmail;
    @JsonView(value={View.class})
    protected String accountTelPhone;
    @JsonView(value={View.class, RedisView.class})
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    protected Date lastLoginTime;

    public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
        this.businessExtensionAttribute = (String)ObjectUtils.defaultIfNull((Object)businessExtensionAttribute, (Object)"");
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = (String)ObjectUtils.defaultIfNull((Object)invoiceType, (Object)"");
    }

    public void setPrintingEquipment(String printingEquipment) {
        this.printingEquipment = (String)ObjectUtils.defaultIfNull((Object)printingEquipment, (Object)"");
    }

    public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
        this.ticketOpeningTerminal = (String)ObjectUtils.defaultIfNull((Object)ticketOpeningTerminal, (Object)"");
    }

    @JsonView(value={UserView.UserInfo.class})
    public Set<O> getOrgs() {
        return this.currentOrgs;
    }

    @JsonView(value={UserView.UserInfo.class, RedisView.class})
    public Set<O> getCurrentOrgs() {
        return this.currentOrgs;
    }

    @JsonView(value={View.class, RedisView.class})
    public A getAccount() {
        return this.account;
    }

    @JsonView(value={View.class})
    public boolean isExpired() {
        if (this.expiredDate == null) {
            return false;
        }
        return DateUtils.beforeNow(this.expiredDate, false);
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserIdCard(String userIdCard) {
        this.userIdCard = userIdCard;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JsonView(value={View.class, RedisView.class})
    public void setUserPeriodTime(Date userPeriodTime) {
        this.userPeriodTime = userPeriodTime;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = userWorkTel;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setContactAddr(String contactAddr) {
        this.contactAddr = contactAddr;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setAccount(A account) {
        this.account = account;
    }

    public void setFilterParentIdSet(Set<String> filterParentIdSet) {
        this.filterParentIdSet = filterParentIdSet;
    }

    @JsonView(value={View.class, RedisView.class})
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @JsonView(value={View.class})
    public void setOrgRelType(Integer orgRelType) {
        this.orgRelType = orgRelType;
    }

    @JsonView(value={View.Tree.class, View.List.class, RedisView.class})
    public void setIsOrgAdmin(Boolean isOrgAdmin) {
        this.isOrgAdmin = isOrgAdmin;
    }

    @JsonView(value={View.Tree.class, View.List.class})
    public void setHasFullOrgs(Boolean hasFullOrgs) {
        this.hasFullOrgs = hasFullOrgs;
    }

    @JsonView(value={UserView.UserInfo.class, View.Tree.class, View.List.class})
    public void setIsLastTenantAdmin(Boolean isLastTenantAdmin) {
        this.isLastTenantAdmin = isLastTenantAdmin;
    }

    @JsonView(value={UserView.UserInfo.class, View.Tree.class, View.List.class})
    public void setIsTenantAdmin(Boolean isTenantAdmin) {
        this.isTenantAdmin = isTenantAdmin;
    }

    @JsonView(value={View.class})
    public void setAccountUserName(String accountUserName) {
        this.accountUserName = accountUserName;
    }

    @JsonView(value={View.class})
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    @JsonView(value={View.class})
    public void setAccountTelPhone(String accountTelPhone) {
        this.accountTelPhone = accountTelPhone;
    }

    @JsonView(value={View.class, RedisView.class})
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public String getUserPhone() {
        return this.userPhone;
    }

    public Integer getUserSex() {
        return this.userSex;
    }

    public String getUserEmailAddr() {
        return this.userEmailAddr;
    }

    public String getUserIdCard() {
        return this.userIdCard;
    }

    public Date getUserPeriodTime() {
        return this.userPeriodTime;
    }

    public String getUserWorkTel() {
        return this.userWorkTel;
    }

    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Date getExpiredDate() {
        return this.expiredDate;
    }

    public String getContactAddr() {
        return this.contactAddr;
    }

    public String getBusinessExtensionAttribute() {
        return this.businessExtensionAttribute;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getPrintingEquipment() {
        return this.printingEquipment;
    }

    public String getTicketOpeningTerminal() {
        return this.ticketOpeningTerminal;
    }

    public Set<String> getFilterParentIdSet() {
        return this.filterParentIdSet;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public Integer getOrgRelType() {
        return this.orgRelType;
    }

    public Boolean getIsOrgAdmin() {
        return this.isOrgAdmin;
    }

    public Boolean getHasFullOrgs() {
        return this.hasFullOrgs;
    }

    public Boolean getIsLastTenantAdmin() {
        return this.isLastTenantAdmin;
    }

    public Boolean getIsTenantAdmin() {
        return this.isTenantAdmin;
    }

    public String getAccountUserName() {
        return this.accountUserName;
    }

    public String getAccountEmail() {
        return this.accountEmail;
    }

    public String getAccountTelPhone() {
        return this.accountTelPhone;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String toString() {
        return "UserDto(userNumber=" + this.getUserNumber() + ", userPhone=" + this.getUserPhone() + ", userSex=" + this.getUserSex() + ", userEmailAddr=" + this.getUserEmailAddr() + ", userIdCard=" + this.getUserIdCard() + ", userPeriodTime=" + this.getUserPeriodTime() + ", userWorkTel=" + this.getUserWorkTel() + ", activeStatus=" + this.getActiveStatus() + ", status=" + this.getStatus() + ", createTime=" + this.getCreateTime() + ", createrId=" + this.getCreaterId() + ", createrName=" + this.getCreaterName() + ", updaterId=" + this.getUpdaterId() + ", updaterName=" + this.getUpdaterName() + ", updateTime=" + this.getUpdateTime() + ", expiredDate=" + this.getExpiredDate() + ", contactAddr=" + this.getContactAddr() + ", businessExtensionAttribute=" + this.getBusinessExtensionAttribute() + ", invoiceType=" + this.getInvoiceType() + ", printingEquipment=" + this.getPrintingEquipment() + ", ticketOpeningTerminal=" + this.getTicketOpeningTerminal() + ", account=" + this.getAccount() + ", filterParentIdSet=" + this.getFilterParentIdSet() + ", sourceType=" + this.getSourceType() + ", orgRelType=" + this.getOrgRelType() + ", isOrgAdmin=" + this.getIsOrgAdmin() + ", hasFullOrgs=" + this.getHasFullOrgs() + ", isLastTenantAdmin=" + this.getIsLastTenantAdmin() + ", isTenantAdmin=" + this.getIsTenantAdmin() + ", accountUserName=" + this.getAccountUserName() + ", accountEmail=" + this.getAccountEmail() + ", accountTelPhone=" + this.getAccountTelPhone() + ", lastLoginTime=" + this.getLastLoginTime() + ")";
    }

    public static final class Fields {
        public static final String userNumber = "userNumber";
        public static final String userPhone = "userPhone";
        public static final String userSex = "userSex";
        public static final String userEmailAddr = "userEmailAddr";
        public static final String userIdCard = "userIdCard";
        public static final String userPeriodTime = "userPeriodTime";
        public static final String userWorkTel = "userWorkTel";
        public static final String activeStatus = "activeStatus";
        public static final String status = "status";
        public static final String createTime = "createTime";
        public static final String createrId = "createrId";
        public static final String createrName = "createrName";
        public static final String updaterId = "updaterId";
        public static final String updaterName = "updaterName";
        public static final String updateTime = "updateTime";
        public static final String expiredDate = "expiredDate";
        public static final String contactAddr = "contactAddr";
        public static final String businessExtensionAttribute = "businessExtensionAttribute";
        public static final String invoiceType = "invoiceType";
        public static final String printingEquipment = "printingEquipment";
        public static final String ticketOpeningTerminal = "ticketOpeningTerminal";
        public static final String account = "account";
        public static final String filterParentIdSet = "filterParentIdSet";
        public static final String sourceType = "sourceType";
        public static final String orgRelType = "orgRelType";
        public static final String isOrgAdmin = "isOrgAdmin";
        public static final String hasFullOrgs = "hasFullOrgs";
        public static final String isLastTenantAdmin = "isLastTenantAdmin";
        public static final String isTenantAdmin = "isTenantAdmin";
        public static final String accountUserName = "accountUserName";
        public static final String accountEmail = "accountEmail";
        public static final String accountTelPhone = "accountTelPhone";
        public static final String lastLoginTime = "lastLoginTime";

        private Fields() {
        }
    }
}

