/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.enums.cloudshell;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum ParticipantType {
    TENANT("\u79df\u6237", "T"),
    SERVICE_PACKAGE("\u670d\u52a1\u5305", "SP"),
    ROLE("\u89d2\u8272", "R"),
    RESOURCE_SET("\u529f\u80fd\u96c6", "RS"),
    RESOURCE_CODE("\u8d44\u6e90\u7801", "RC"),
    ORG("\u7ec4\u7ec7", "O"),
    COMPANY("\u516c\u53f8", "C"),
    ORG_TYPE("\u81ea\u5b9a\u4e49\u7ec4\u7ec7\u7c7b\u578b", "OT");

    private final String name;
    private final String abbr;

    private ParticipantType(String name, String abbr) {
        this.name = name;
        this.abbr = abbr;
    }

    public String getName() {
        return this.name;
    }

    @JsonValue
    public String abbr() {
        return this.abbr;
    }

    public String generateId(Long id) {
        return this.abbr() + "-" + id;
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ParticipantType fromAbbr(String value) {
        return Stream.of(ParticipantType.values()).filter(type -> type.abbr().equalsIgnoreCase(value) || type.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("No enum constant " + ParticipantType.class.getCanonicalName() + "." + value));
    }
}

