package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collection;
import java.util.Objects;

/**
 * @author geewit
 */
@ApiModel(value = "reactjs tree")
@Setter
@Getter
@ToString
public class TreeNode {
    @ApiModelProperty("key")
    private Long key;

    @JsonIgnore
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("title")
    private String title;

    @ApiModelProperty("pid")
    @JsonIgnore
    private Long pid;

    @ApiModelProperty("parentKey")
    @JsonIgnore
    private String parentKey;

    @ApiModelProperty("children")
    private Collection<TreeNode> children;

}
