package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;
/***
 * @author HuangFang
 */
@ApiModel(value = "公司扩展")
public class CompanyExtensionDto extends ExtensionDto {
    @ApiModelProperty("公司id")
    @JsonView(View.class)
    protected Long companyId;

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompanyExtensionDto) {
            CompanyExtensionDto that = (CompanyExtensionDto) o;
            return this.companyId.equals(that.getCompanyId()) && super.getExtensionKey().equals(that.getExtensionKey());
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.companyId, super.getExtensionKey());
    }
}
