package com.xforceplus.domain.user;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;


/***
 * @author HuangFang
 */
@ApiModel(value = "用户")
public class UserDto<O extends OrgDto<O, E>, R extends RoleDto, A extends AccountDto, E extends OrgExtensionDto> extends AuthorizedUser<O, R> implements IAuthorizedUser<O, R>, IOperator {
    @ApiModelProperty(value = "用户编码", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userNumber;

    @ApiModelProperty(value = "用户名称", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userName;

    @ApiModelProperty(value = "联系电话")
    @JsonView(View.class)
    protected String userPhone;

    @ApiModelProperty(value = "性别")
    @JsonView(View.class)
    protected Integer userSex;

    @JsonView(View.class)
    protected String userEmailAddr;

    @JsonView(View.class)
    protected String userIdCard;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView(View.class)
    protected Date userPeriodTime;

    @JsonView(View.class)
    protected String userWorkTel;

    @JsonView(View.class)
    protected Integer activeStatus;

    @JsonView(View.class)
    protected Integer userType;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView(View.class)
    protected String contactAddr;

    @ApiModelProperty("业务扩展属性")
    @JsonView(View.class)
    protected String businessExtensionAttribute;
    @ApiModelProperty(value = "发票类型", notes = "c：普票；s：专票；cs：专票和普票 ce：普电票")
    @JsonView(View.class)
    protected String invoiceType;
    @ApiModelProperty(value = "打印设备", notes = "多个打印设备值用','隔开")
    @JsonView(View.class)
    protected String printingEquipment;
    @ApiModelProperty(value = "开票终端", notes = "多个开票终端用','分隔开")
    @JsonView(View.class)
    protected String ticketOpeningTerminal;

    @ApiModelProperty("账号信息")
    protected A account;

    public String getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    public String getUserIdCard() {
        return userIdCard;
    }

    public void setUserIdCard(String userIdCard) {
        this.userIdCard = userIdCard;
    }

    public Date getUserPeriodTime() {
        return userPeriodTime;
    }

    public void setUserPeriodTime(Date userPeriodTime) {
        this.userPeriodTime = userPeriodTime;
    }

    public String getUserWorkTel() {
        return userWorkTel;
    }

    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = userWorkTel;
    }

    public Integer getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getContactAddr() {
        return contactAddr;
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = contactAddr;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getBusinessExtensionAttribute() {
        return businessExtensionAttribute;
    }

    public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
        this.businessExtensionAttribute = businessExtensionAttribute;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getPrintingEquipment() {
        return printingEquipment;
    }

    public void setPrintingEquipment(String printingEquipment) {
        this.printingEquipment = printingEquipment;
    }

    public String getTicketOpeningTerminal() {
        return ticketOpeningTerminal;
    }

    public void setTicketOpeningTerminal(String ticketOpeningTerminal) {
        this.ticketOpeningTerminal = ticketOpeningTerminal;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Override
    public Set<R> getRoles() {
        return roles;
    }

    @Override
    public void setRoles(Set<R> roles) {
        this.roles = roles;
    }

    @Override
    public Set<O> getParentOrgs() {
        return super.parentOrgs;
    }

    @Override
    public void setParentOrgs(Set<O> parentOrgs) {
        super.parentOrgs = parentOrgs;
    }

    @Override
    public Set<String> getResourceCodes() {
        return resourceCodes;
    }

    @Override
    public void setResourceCodes(Set<String> resourceCodes) {
        this.resourceCodes = resourceCodes;
    }

    @SuppressWarnings("all")
    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getOrgs() {
        return currentOrgs;
    }

    @Override
    public void setOrgs(Set<O> orgs) {
        this.currentOrgs = orgs;
    }

    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getCurrentOrgs() {
        return currentOrgs;
    }

    @Override
    public void setCurrentOrgs(Set<O> currentOrgs) {
        this.currentOrgs = currentOrgs;
    }

    @JsonView(UserView.UserInfo.class)
    public A getAccount() {
        return account;
    }

    public void setAccount(A account) {
        this.account = account;
    }
}
