/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: StringIncludeValidator.java   2020-09-25 14-20-29
 * Author: Evan
 */
package com.xforceplus.validation.validator;

import com.xforceplus.validation.constraints.StringInclude;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * Title: StringIncludeValidator校验器
 * </p>
 * <p>
 * Description: StringIncludeValidator校验器 可以设置 required=false,当字段为空时，则不校验并返回true
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-25 14-20-29
 * @since V1.0
 */
public class StringIncludeValidator implements ConstraintValidator<StringInclude, String> {
    /**
     * 日志
     */
    private static final Logger log = LoggerFactory.getLogger(StringIncludeValidator.class);


    private boolean required;

    private List<String> strList = Collections.emptyList();

    /***
     * 初始化校验器
     * @param stringInclude
     */
    @Override
    public void initialize(StringInclude stringInclude) {
        log.info("stringInclude:{}", stringInclude.toString());
        this.required=stringInclude.required();
        strList=Arrays.asList(stringInclude.range());
    }

    /***
     * 重写校验
     * @param value
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        //如果表明为必要验证，则不允许为空，否则可以为空
        if (StringUtils.isBlank(value)) {
            return !this.required;
        }
        //验证器
        return this.strList.contains(value);
    }
}
