/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.domain.device;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InvoiceType {
    NORMAL("c"),
    SPECIAL("s"),
    VEHICLE("v"),
    UNIVERSAL("t"),
    ELECTRONIC("ce"),
    NORMAL_ROLL("ju"),
    NORMAL_SPECIAL("cs"),
    SPECIAL_ELECTRONIC("se");

    private final String type;

    private InvoiceType(String type) {
        this.type = type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.value(), SPECIAL_ELECTRONIC.value());
    }

    public static List<String> toList() {
        List<String> invoiceTypes = Stream.of(InvoiceType.values()).map(e -> e.value()).collect(Collectors.toList());
        return invoiceTypes;
    }

    public String value() {
        return this.type;
    }

    public boolean isNormal() {
        return this.equals((Object)NORMAL) || this.equals((Object)ELECTRONIC) || this.equals((Object)NORMAL_ROLL);
    }

    public boolean isSpecial() {
        return this.equals((Object)SPECIAL) || this.equals((Object)SPECIAL_ELECTRONIC);
    }
}

