package com.xforceplus.domain.account;

import java.util.Objects;
/***
 * @author HuangFang
 */
public class AccountExceptionDto extends AccountDto {
    private String errorMsg;

    public AccountExceptionDto() {
        super();
    }

    public AccountExceptionDto(String msg) {
        super();
        this.errorMsg = msg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountExceptionDto that = (AccountExceptionDto) o;
        return Objects.equals(errorMsg, that.errorMsg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorMsg);
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
