package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;


/**
 * 组织
 *
 * @author geewit
 */
@SuppressWarnings("all")
@ApiModel("组织")
public class OrgDto<O extends OrgDto<O, E>, E extends OrgExtensionDto> extends Org<O> implements IOperator {
    @JsonView(View.class)
    @ApiModelProperty(value = "组织描述")
    protected String orgDesc;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "公司审核状态", notes = "0:待审核，1:审核通过, 2:审核失败")
    @JsonView(View.class)
    protected Integer auditStatus;

    @ApiModelProperty(value = "状态启用时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date enabledTime;

    @ApiModelProperty(value = "状态注销时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date disabledTime;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户code")
    protected String tenantCode;

    @ApiModelProperty(value = "上级组织名称")
    @JsonView(View.class)
    protected String parentName;

    @ApiModelProperty(value = "归属用户数量")
    @JsonView(View.class)
    protected Long userCount;

    @ApiModelProperty(value = "用户绑定勾选状态")
    @JsonView(View.class)
    protected Boolean userBound;

    @ApiModelProperty("公司代码集合")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView(View.class)
    protected Set<String> companyNos;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("组织扩展信息")
    protected Set<E> extensions;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("父级组织集合")
    protected List<O> parentOrgs;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getOrgId() {
        return orgId;
    }

    @Override
    public String getOrgCode() {
        return orgCode;
    }

    @Override
    public String getOrgName() {
        return orgName;
    }

    public String getOrgDesc() {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getCompanyId() {
        return companyId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getParentId() {
        return parentId;
    }

    @Override
    public String getParentIds() {
        return parentIds;
    }

    @Override
    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    @Override
    public OrgType getOrgType() {
        return orgType;
    }

    @JsonView(View.List.class)
    @Override
    public String getTaxNum() {
        return super.taxNum;
    }

    @JsonView(View.List.class)
    @Override
    public String getCompanyName() {
        return super.companyName;
    }

    @ApiModelProperty(value = "公司code")
    @Override
    @JsonView(View.List.class)
    public String getCompanyCode() {
        return super.companyCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Date getEnabledTime() {
        return enabledTime;
    }

    public void setEnabledTime(Date enabledTime) {
        this.enabledTime = enabledTime;
    }

    public Date getDisabledTime() {
        return disabledTime;
    }

    public void setDisabledTime(Date disabledTime) {
        this.disabledTime = disabledTime;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUserCount() {
        return userCount;
    }

    public void setUserCount(Long userCount) {
        this.userCount = userCount;
    }

    public Boolean getUserBound() {
        return userBound;
    }

    public void setUserBound(Boolean userBound) {
        this.userBound = userBound;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Set<String> getCompanyNos() {
        return companyNos;
    }

    public void setCompanyNos(Set<String> companyNos) {
        this.companyNos = companyNos;
    }

    public Set<E> getExtensions() {
        return extensions;
    }

    public void setExtensions(Set<E> extensions) {
        this.extensions = extensions;
    }

    public List<O> getParentOrgs() {
        return parentOrgs;
    }

    public void setParentOrgs(List<O> parentOrgs) {
        this.parentOrgs = parentOrgs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgDto)) {
            return false;
        }
        OrgDto that = (OrgDto) o;
        return Objects.equals(super.orgId, that.orgId) || (Objects.equals(super.tenantId, that.tenantId) && Objects.equals(super.orgCode, that.orgCode));
    }

    @Override
    public int hashCode() {
        if(super.orgId != null && super.orgId > 0) {
            return Objects.hash(super.orgId);
        }
        return Objects.hash(super.tenantId, super.orgCode);
    }
}
