package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/***
 * @author HuangFang
 */
@ApiModel(value = "租户扩展")
public class TenantExtensionDto extends ExtensionDto {
    @ApiModelProperty("租户id")
    @JsonView(View.class)
    protected Long tenantId;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TenantExtensionDto) {
            TenantExtensionDto that = (TenantExtensionDto) o;
            return this.tenantId.equals(that.getTenantId()) && super.getExtensionKey().equals(that.getExtensionKey());
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId, super.getExtensionKey());
    }
}
