package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.json.ExtensionView;
import com.xforceplus.tenant.security.core.domain.ICompany;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
/***
 * @author HuangFang
 */
@SuppressWarnings("all")
@Setter
@Getter
@ApiModel(value = "公司")
public class CompanyDto<T extends TenantDto, E extends CompanyExtensionDto> implements ICompany, IOperator {
    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "公司id")
    protected Long companyId;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "企业编码")
    protected String companyCode;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "企业名称")
    protected String companyName;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "税号")
    protected String taxNum;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营所在省份")
    protected String locationArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营所在市区")
    protected String locationCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营详细地址")
    protected String locationAddr;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营电话")
    protected String companyPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业期限开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date businessStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业期限结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date businessEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业时间是否长期")
    protected Integer businessTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业经营范围")
    protected String businessScope;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业Logo")
    protected String companyLogo;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业执照影像")
    protected String businessLicense;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "平台管理人身份", notes = "0:法定代表人, 1:代理人")
    protected Integer platManagerStatus;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人归属地")
    protected String managerLocation;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人姓名")
    protected String managerName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件类型  1-身份证")
    protected String managerCardType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人身份证")
    protected String managerIdCard;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人联系方式")
    protected String managerPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date managerIdCardStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date managerIdCardEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人身份证长期")
    protected Integer managerIdCardTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件正面照")
    protected String managerIdCardFrontPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件背面照")
    protected String managerIdCardBackPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "开户行名称")
    protected String bankName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "开户银行支行名称")
    protected String bankBranchName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "对公银行账户")
    protected String bankNo;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "银行所在省份")
    protected String bankArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "银行所在市区")
    protected String bankCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "注销/启用原因")
    protected String operateReason;

    @JsonView({View.class})
    @ApiModelProperty(value = "传统认证管理状态", notes = "1:开启；0:关闭")
    protected Integer traditionAuthenFlag;

    @JsonView({View.class})
    @ApiModelProperty(value = "查验服务状态", notes = "1:开启；0:关闭")
    protected Integer inspectionServiceFlag;

    @JsonView({View.class})
    @ApiModelProperty(value = "极速查验通道状态", notes = "1:开启；0:关闭")
    protected Integer speedInspectionChannelFlag;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "增值税普通发票限额")
    protected BigDecimal cquota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税专用发票限额")
    protected BigDecimal squota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税电子普通发票限额")
    protected BigDecimal ceQuota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税普通发票-卷票限额")
    protected BigDecimal juQuota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税电子专票限额")
    protected BigDecimal seQuota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册省份")
    protected String registLocationArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册城市")
    protected String registLocationCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册详细地址")
    protected String registLocationAddr;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")
    protected Integer taxpayerQualificationType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "纳税人资质证书")
    protected String taxpayerQualification;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人姓名")
    protected String proxyManagerName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证据类型  1-身份证")
    protected String proxyManagerCardType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人身份证")
    protected String proxyManagerIdCard;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人联系方式")
    protected String proxyManagerPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date proxyManagerIdCardStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date proxyManagerIdCardEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人身份证长期")
    protected Integer proxyManagerIdCardTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件正面照")
    protected String proxyManagerIdCardFrontPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件背面照")
    protected String proxyManagerIdCardBackPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "认证方式")
    protected String identificationType;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date effectiveDate;

    @ApiModelProperty(value = "是否生效")
    protected Boolean effective;
    @JsonView({View.Page.class, ExtensionView.Extension.class})
    protected List<E> extensions;

    @ApiModelProperty(value = "关联租户集合")
    @JsonView({View.Info.class})
    protected List<T> tenants;

    protected Long tenantId;
    /**
     * 租户用户名
     */
    protected String tenantName;
    /**
     * 租户代码
     */
    protected String tenantCode;

}
