package com.xforceplus.domain.orgVirtual;


import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

public class OrgVirtualDTO implements IOperator {

	/**
	 * 虚拟组织id
	 */
	@ApiModelProperty(value = "虚拟组织id")
	protected Long orgVirtualId;


	/**
	 * 虚拟组织id
	 */
	@ApiModelProperty(value = "实体组织id")
	protected Long orgStructId;


	/**
	 * 租户id
	 */
	@ApiModelProperty(value = "租户id")
	protected Long tenantId;

	/**
	 * 组织代码
	 */
	@ApiModelProperty(value = "组织代码")
	protected String orgCode;

	/**
	 * 组织名称
	 */
	@ApiModelProperty(value = "组织名称")
	protected String orgName;

	/**
	 * 简称
	 */
	@ApiModelProperty(value = "简称")
	protected String shortName;

	/**
	 * 组织备注
	 */
	@ApiModelProperty(value = "组织备注")
	protected String orgDesc;

	/**
	 * 状态：0 停用 1 启用
	 */
	@ApiModelProperty(value = "状态：0 停用 1 启用")
	protected Integer status;

	@JsonView({View.class})
	@ApiModelProperty(value = "创建时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	protected Date createTime;

	@ApiModelProperty(value = "创建人id")
	protected String createrId;

	@ApiModelProperty(value = "创建人名称")
	protected String createrName;

	@ApiModelProperty(value = "更新人id")
	protected String updaterId;

	@ApiModelProperty(value = "更新人名称")
	protected String updaterName;

	@JsonView({View.class})
	@ApiModelProperty(value = "更新时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	protected Date updateTime;

	/**
	 * 组织树id
	 */
	@ApiModelProperty(value = "组织树id")
	protected Long orgVirtualNodeId;

	public Long getOrgVirtualId() {
		return orgVirtualId;
	}

	public void setOrgVirtualId(Long orgVirtualId) {
		this.orgVirtualId = orgVirtualId;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public Long getOrgStructId() {
		return orgStructId;
	}

	public void setOrgStructId(Long orgStructId) {
		this.orgStructId = orgStructId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getOrgDesc() {
		return orgDesc;
	}

	public void setOrgDesc(String orgDesc) {
		this.orgDesc = orgDesc;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	@Override
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@Override
	public String getCreaterId() {
		return createrId;
	}

	@Override
	public void setCreaterId(String createrId) {
		this.createrId = createrId;
	}

	@Override
	public String getCreaterName() {
		return createrName;
	}

	@Override
	public void setCreaterName(String createrName) {
		this.createrName = createrName;
	}

	@Override
	public String getUpdaterId() {
		return updaterId;
	}

	@Override
	public void setUpdaterId(String updaterId) {
		this.updaterId = updaterId;
	}

	@Override
	public String getUpdaterName() {
		return updaterName;
	}

	@Override
	public void setUpdaterName(String updaterName) {
		this.updaterName = updaterName;
	}

	@Override
	public Date getUpdateTime() {
		return updateTime;
	}

	@Override
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Long getOrgVirtualNodeId() {
		return orgVirtualNodeId;
	}

	public void setOrgVirtualNodeId(Long orgVirtualNodeId) {
		this.orgVirtualNodeId = orgVirtualNodeId;
	}
}
