package com.xforceplus.domain.orgVirtual;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/23 10:34
 * 功能描述:
 * 修改历史:
 */
@ApiModel(value = "reactjs tree")
@Setter
@Getter
@ToString
public class OrgVirtualTreeNode {
    @ApiModelProperty("key")
    private Long key;

    @ApiModelProperty("orgCode")
    private String orgCode;

    @ApiModelProperty("orgName")
    private String orgName;

    @ApiModelProperty("shortName")
    private String shortName;

    @ApiModelProperty("orgDesc")
    private String orgDesc;

    @ApiModelProperty("pid")
    @JsonIgnore
    private Long pid;

    @ApiModelProperty("children")
    private Set<OrgVirtualTreeNode> children;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgVirtualTreeNode node = (OrgVirtualTreeNode) o;
        return key.equals(node.key) &&
                pid.equals(node.pid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, pid);
    }
}
