package com.xforceplus.domain.resource;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCheckExistsPathResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("check")
  private boolean check ;


  @JsonIgnore
  public MsCheckExistsPathResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCheckExistsPathResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }


  @JsonIgnore
  public MsCheckExistsPathResponse check(Boolean check) {
    this.check = check;
    return this;
  }

   /**
   * check
   * @return check
  **/
  @ApiModelProperty(value = "check")
  public boolean getCheck() {
    return check;
  }

  public void setCheck(boolean check) {
    this.check = check;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCheckExistsPathResponse checkExistsPathResponse = (MsCheckExistsPathResponse) o;
    return Objects.equals(this.code, checkExistsPathResponse.code) &&
        Objects.equals(this.message, checkExistsPathResponse.message) &&
        Objects.equals(this.check, checkExistsPathResponse.check);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, check);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCheckExistsPathResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    check: ").append(toIndentedString(check)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
