package com.xforceplus.domain.resource;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Set;
/***
 * @author HuangFang
 */
public class RequestUriAuthz implements Serializable {
    private Set<String> resourceCodes;
    @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
    private Boolean skipAuthentication;

    @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
    private Boolean skipAuthorization;

    public RequestUriAuthz() {
    }

    public RequestUriAuthz(Set<String> resourceCodes, Boolean skipAuthentication, Boolean skipAuthorization) {
        this.resourceCodes = resourceCodes;
        this.skipAuthentication = skipAuthentication;
        this.skipAuthorization = skipAuthorization;
    }

    public Set<String> getResourceCodes() {
        return resourceCodes;
    }

    public void setResourceCodes(Set<String> resourceCodes) {
        this.resourceCodes = resourceCodes;
    }

    public Boolean getSkipAuthentication() {
        return skipAuthentication;
    }

    public void setSkipAuthentication(Boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
    }

    public Boolean getSkipAuthorization() {
        return skipAuthorization;
    }

    public void setSkipAuthorization(Boolean skipAuthorization) {
        this.skipAuthorization = skipAuthorization;
    }
}
