/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: RoleResourceDTO.java   2020-12-21 22-55-45
 * Author: Evan
 */
package com.xforceplus.domain.tenant;

import com.xforceplus.domain.resource.ResourcesetDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * <p>
 * Title: 角色与资源码关系
 * </p>
 * <p>
 * Description: 角色与资源码关系（产品服务包、功能集、资源码）
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-21 22-55-45
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class RoleResourceDTO implements Serializable {
    /**
     * ID资源（PG_ID||RS-）
     */
    @ApiModelProperty(value = "KEY")
    private String key;
    /**
     * 服务包||功能集||资源码
     */
    @ApiModelProperty(value = "资源类型")
    private String type;
    /**
     * 服务包ID
     */
    @ApiModelProperty(value = "服务包ID")
    protected Long servicePackageId;
    /**
     * 资源码ID
     */
    @ApiModelProperty(value = "资源码ID")
    private Long resourceId;
    /**
     * 功能集ID
     */
    @ApiModelProperty(value = "功能集ID")
    private Long resourceSetId;
    /**
     * 资源码|功能集Code
     */
    @ApiModelProperty(value = "资源码|功能集Code")
    private String itemCode;
    /**
     * 资源名称|功能集名称
     */
    @ApiModelProperty(value = "资源名称|功能集名称")
    private String itemName;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态，1启用，0停用")
    private Integer status;
    /**
     * 自定义功能集的角色Id
     */
    @ApiModelProperty(value = "自定义功能集的角色Id")
    private Long roleId;

    /**
     * 是否为自定义功能集状态
     */
    @ApiModelProperty(value = "自定义功能集的角色Id",notes = "1 表示为自定义功能集，0表示为 非自定义功能集")
    private Long definedStatus;
}
