package com.xforceplus.domain.client;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.oltu.oauth2.common.message.types.GrantType;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/***
 * @author geewit
 */
public class ClientDto {


    /**
     * 物理主键
     */
    protected Long id;

    @JsonView(TokenView.class)
    @ApiModelProperty("clientId")
    @NotBlank(message = "clientId不能为空")
    protected String clientId;

    @ApiModelProperty("secret")
    @NotBlank(message = "secret不能为空")
    protected String secret;

    @JsonView(TokenView.class)
    @ApiModelProperty("client名称")
    @NotBlank(message = "clientName不能为空")
    protected String clientName;

    @JsonView(TokenView.class)
    @ApiModelProperty("appId")
    @NotNull(message = "appId不能为空")
    @Min(value = 1L, message = "appId需要大于0")
    protected Integer appId;

    @ApiModelProperty("scope")
    protected String scope;

    @ApiModelProperty("grantType")
    protected GrantType grantType;

    @ApiModelProperty("跳转地址")
    protected String redirectUri;

    @JsonView(TokenView.class)
    @ApiModelProperty("扩展信息")
    protected String extension;

    @ApiModelProperty("状态")
    protected Boolean status;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    protected Date createTime;

    @JsonView(TokenView.class)
    @ApiModelProperty("关联租户id")
    protected List<Long> tenantIds;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Integer getAppId() {
        return appId;
    }

    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public GrantType getGrantType() {
        return grantType;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<Long> getTenantIds() {
        return tenantIds;
    }

    public void setTenantIds(List<Long> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
