package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/***
 * @author HuangFang
 */
@ApiModel(value = "组织扩展")
public class OrgExtensionDto extends ExtensionDto {

    @ApiModelProperty("组织id")
    @JsonView(View.class)
    protected Long orgStructId;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户code")
    protected String tenantCode;

    @JsonView({View.List.class})
    @ApiModelProperty("组织名称")
    protected String orgName;

    public Long getOrgStructId() {
        return orgStructId;
    }

    public void setOrgStructId(Long orgStructId) {
        this.orgStructId = orgStructId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OrgExtensionDto) {
            OrgExtensionDto that = (OrgExtensionDto) o;
            return this.orgStructId.equals(that.getOrgStructId()) && super.getExtensionKey().equals(that.getExtensionKey());
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.orgStructId, super.getExtensionKey());
    }
}
