package com.xforceplus.domain.orgVirtual;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

public class OrgVirtualNodeDTO implements IOperator {

	/**
	 * 主键
	 */
	@ApiModelProperty(value = "主键")
	protected Long orgVirtualNodeId;

	/**
	 * 虚拟组织ID
	 */
	@ApiModelProperty(value = "虚拟组织ID")
	protected Long orgVirtualId;

	/**
	 * 租户id
	 */
	@ApiModelProperty(value = "租户id")
	protected Long tenantId;

	/**
	 * 上级组织id
	 */
	@ApiModelProperty(value = "上级组织id")
	protected Long parentId;

	/**
	 * 上级组织路径
	 */
	@ApiModelProperty(value = "上级组织路径")
	protected String parentIds;

	/**
	 * 组织类型id
	 */
	@ApiModelProperty(value = "组织类型id")
	protected Long nodeTypeId;

	/**
	 * 下级组织数量
	 */
	@ApiModelProperty(value = "下级组织数量")
	protected Integer childrenCount;

	@JsonView({View.class})
	@ApiModelProperty(value = "创建时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	protected Date createTime;

	@ApiModelProperty(value = "创建人id")
	protected String createrId;

	@ApiModelProperty(value = "创建人名称")
	protected String createrName;

	@ApiModelProperty(value = "更新人id")
	protected String updaterId;

	@ApiModelProperty(value = "更新人名称")
	protected String updaterName;

	@JsonView({View.class})
	@ApiModelProperty(value = "更新时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	protected Date updateTime;


	public Long getOrgVirtualId() {
		return orgVirtualId;
	}

	public void setOrgVirtualId(Long orgVirtualId) {
		this.orgVirtualId = orgVirtualId;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Integer getChildrenCount() {
		return childrenCount;
	}

	public void setChildrenCount(Integer childrenCount) {
		this.childrenCount = childrenCount;
	}

	public String getParentIds() {
		return parentIds;
	}

	public void setParentIds(String parentIds) {
		this.parentIds = parentIds;
	}

	@Override
    public Date getCreateTime() {
		return createTime;
	}

	@Override
    public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@Override
    public String getCreaterId() {
		return createrId;
	}

	@Override
    public void setCreaterId(String createrId) {
		this.createrId = createrId;
	}

	@Override
    public String getCreaterName() {
		return createrName;
	}

	@Override
    public void setCreaterName(String createrName) {
		this.createrName = createrName;
	}

	@Override
	public String getUpdaterId() {
		return updaterId;
	}

	@Override
	public void setUpdaterId(String updaterId) {
		this.updaterId = updaterId;
	}

	@Override
	public String getUpdaterName() {
		return updaterName;
	}

	@Override
	public void setUpdaterName(String updaterName) {
		this.updaterName = updaterName;
	}

	@Override
	public Date getUpdateTime() {
		return updateTime;
	}

	@Override
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Long getOrgVirtualNodeId() {
		return orgVirtualNodeId;
	}

	public void setOrgVirtualNodeId(Long orgVirtualNodeId) {
		this.orgVirtualNodeId = orgVirtualNodeId;
	}

	public Long getNodeTypeId() {
		return nodeTypeId;
	}

	public void setNodeTypeId(Long nodeTypeId) {
		this.nodeTypeId = nodeTypeId;
	}
}
