package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import com.xforceplus.domain.validation.ValidationGroup;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;
/***
 * @author HuangFang
 */
@ApiModel(value = "服务包")
public class ServicePackageDto implements IOperator {
    @ApiModelProperty("服务包id")
    @JsonView(View.class)
    protected Long servicePackageId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    @Min(1)
    @NotNull(groups = ValidationGroup.OnCreate.class)
    protected Long appId;


    @ApiModelProperty("服务包code")
    @JsonView(View.class)
    @Pattern(regexp = "\\s*|[a-zA-Z\\d_\\-]+", groups = {ValidationGroup.OnCreate.class, ValidationGroup.OnUpdate.class}, message = "代码不能有汉字")
    protected String servicePackageCode;
    @ApiModelProperty("服务包名称")
    @JsonView(View.class)
    @NotEmpty(groups = ValidationGroup.OnCreate.class)
    protected String servicePackageName;
    @ApiModelProperty("服务包描述")
    @JsonView(View.class)
    protected String servicePackageDesc;
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @Range(max = 1L, min=0L)
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "创建时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    public ServicePackageDto() {
    }

    public ServicePackageDto(Long servicePackageId, String servicePackageName, Long appId) {
        this.servicePackageId = servicePackageId;
        this.servicePackageName = servicePackageName;
        this.appId = appId;
    }

    public Long getServicePackageId() {
        return servicePackageId;
    }

    public void setServicePackageId(Long servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getServicePackageCode() {
        return servicePackageCode;
    }

    public void setServicePackageCode(String servicePackageCode) {
        this.servicePackageCode = servicePackageCode;
    }

    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
