/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: RoleBindDTO.java   2020-12-21 23-10-45
 * Author: Evan
 */
package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * Title: 角色绑定
 * </p>
 * <p>
 * Description: 角色绑定（返回当前角色，角色绑定功能集及资源码）
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-21 23-10-45
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class RoleBindDTO implements Serializable {

    @ApiModelProperty("角色id")
    protected Long id;
    @ApiModelProperty("租户id")
    protected Long tenantId;
    @ApiModelProperty("角色代码")
    protected String code;
    @ApiModelProperty("角色名称")
    protected String name;
    @ApiModelProperty(value = "角色描述")
    protected String roleDesc;
    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    protected Integer status;
    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("角色标签集合")
    protected Set<Tag> tags;
    /**
     * 角色与资源列表（产品服务、功能集、资源码）
     */
    @ApiModelProperty(value = "资源列表")
    private List<RoleResourceDTO> resourceDTOList;


}
