package com.xforceplus.domain.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/***
 * @author geewit
 */
@ApiModel(value = "帐号")
public class AccountDto implements IOperator {

    @JsonView(View.class)
    @ApiModelProperty(value = "帐号id")
    protected Long accountId;

    @JsonView(View.class)
    @ApiModelProperty(value = "登录email")
    protected String email;

    @JsonView(View.Internal.class)
    @ApiModelProperty(value = "帐号密码")
    protected String password;

    @JsonView(View.class)
    @ApiModelProperty(value = "登录手机")
    protected String telPhone;

    @JsonView(View.class)
    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @JsonView(View.class)
    @ApiModelProperty(value = "username")
    protected String username;

    @JsonView(View.Info.class)
    protected String salt;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "是否需要改密码")
    protected Boolean changePasswordFlag;

    @ApiModelProperty(value = "密码更新时间")
    protected Date pwdLastUpdateTime;

    @ApiModelProperty(value = "二次验证标识")
    @JsonView(View.class)
    protected Boolean doubleAuthFlag;

    @JsonView(View.class)
    @ApiModelProperty(value = "是否需要绑定手机或者邮箱")
    protected Boolean bindAuthFlag;

    @JsonView(View.class)
    @ApiModelProperty(value = "密码长度")
    protected Integer passwdLength;

    @JsonView(View.class)
    @ApiModelProperty(value = "最近登录时间")
    protected Date lastLoginTime;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getEmail() {
        return email == null ? "" : email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTelPhone() {
        return telPhone == null ? "" : telPhone;
    }

    public void setTelPhone(String telPhone) {
        this.telPhone = telPhone;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUsername() {
        return username == null ? "" : username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountDto that = (AccountDto) o;
        return Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId);
    }

    public Boolean getChangePasswordFlag() {
        return changePasswordFlag;
    }

    public void setChangePasswordFlag(Boolean changePasswordFlag) {
        this.changePasswordFlag = changePasswordFlag;
    }

    public Boolean getBindAuthFlag() {
        return bindAuthFlag;
    }

    public void setBindAuthFlag(Boolean bindAuthFlag) {
        this.bindAuthFlag = bindAuthFlag;
    }

    public Integer getPasswdLength() {
        return passwdLength;
    }

    public void setPasswdLength(Integer passwdLength) {
        this.passwdLength = passwdLength;
    }

    public Date getPwdLastUpdateTime() {
        return pwdLastUpdateTime;
    }

    public void setPwdLastUpdateTime(Date pwdLastUpdateTime) {
        this.pwdLastUpdateTime = pwdLastUpdateTime;
    }

    public Boolean getDoubleAuthFlag() {
        return doubleAuthFlag;
    }

    public void setDoubleAuthFlag(Boolean doubleAuthFlag) {
        this.doubleAuthFlag = doubleAuthFlag;
    }

    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }
}
