package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.ExtensionDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/***
 * @author geewit
 */
@ApiModel(value = "公司扩展")
@Setter
@Getter
public class CompanyExtensionDto extends ExtensionDto {
    @ApiModelProperty("公司id")
    @JsonView(View.class)
    protected Long companyId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompanyExtensionDto) {
            CompanyExtensionDto that = (CompanyExtensionDto) o;
            return this.companyId.equals(that.getCompanyId()) && super.getExtensionKey().equals(that.getExtensionKey());
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.companyId, super.getExtensionKey());
    }
}
