package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.geewit.core.utils.enums.EnumMapUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author geewit
 */
@Setter
@Getter
@ToString
public class CompanyTenantRelDto implements Serializable {
    protected Long id;
    @ApiModelProperty(value = "所属租户主体公司id")
    protected Long invitingCompanyId;
    @ApiModelProperty(value = "所属租户主体公司名称")
    protected String invitingCompanyName;
    @ApiModelProperty(value = "企业id")
    protected Long companyId;
    @ApiModelProperty(value = "企业名称")
    protected String companyName;
    @ApiModelProperty(value = "公司编码")
    protected String companyCode;
    @ApiModelProperty(value = "税号")
    protected String taxNum;
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;
    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;
    @ApiModelProperty(value = "所属租户id")
    protected Long hostTenantId;
    @ApiModelProperty(value = "所属租户名称")
    protected String hostTenantName;
    @ApiModelProperty(value = "所属租户代码")
    protected String hostTenantCode;
    @ApiModelProperty(value = "被关联租户id")
    protected Long relatedTenantId;
    @ApiModelProperty(value = "被关联租户名称")
    protected String relatedTenantName;
    @ApiModelProperty(value = "被关联租户代码")
    protected String relatedTenantCode;
    @ApiModelProperty(value = "被关联公司id")
    protected Long relatedCompanyId;
    @ApiModelProperty(value = "被关联公司税号")
    protected String relatedTaxNum;
    @ApiModelProperty(value = "被关联公司名称")
    protected String relatedCompanyName;
    @ApiModelProperty(value = "被关联公司编码")
    protected String relatedCompanyCode;
    @ApiModelProperty(value = "开关组合", notes = "发票数据:1, 结算单:2, 税控终端&税控设备: 4")
    protected Integer switches;
    @ApiModelProperty(value = "共享历史发票授权时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date invoiceGrantedTime;
    @ApiModelProperty(value = "共享历史发票起始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date invoiceStartDate;
    @ApiModelProperty(value = "共享历史结算单授权时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date statementGrantedTime;
    @ApiModelProperty(value = "共享历史结算单起始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date statementStartDate;
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "开关组合列表", notes = "发票数据:1, 结算单:2, 税控终端&税控设备: 4")
    public List<Integer> getSwitchesList() {
        return Switch.toValues(this.switches);
    }

    @ApiModelProperty(value = "枚举化的开关组合Map")
    public Map<Switch, Boolean> getSwitchesMap() {
        return EnumMapUtils.toEnumMap(Switch.class, this.switches);
    }
}
