package com.xforceplus.domain.resource;

import org.springframework.web.bind.annotation.RequestMethod;

import java.io.Serializable;
import java.util.Objects;

/***
 * @author geewit
 */
public class RequestUri implements Serializable {
    private String requestPath;
    private RequestMethod requestMethod;

    public RequestUri(String requestPath, RequestMethod requestMethod) {
        this.requestPath = requestPath;
        this.requestMethod = requestMethod;
    }

    public String getRequestPath() {
        return requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public RequestMethod getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestUri that = (RequestUri) o;
        return Objects.equals(requestPath, that.requestPath) &&
                requestMethod == that.requestMethod;
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestPath, requestMethod);
    }
}
