package com.xforceplus.domain.sso;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "code协议附加信息")
@Getter
@Setter
public class SsoCodeDto implements Serializable {
    /**
     * ID.
     */
    @ApiModelProperty(value = "ID", notes = "主键")
    @JsonView(View.class)
    protected long id;

    /**
     * 租户ID.
     */
    @ApiModelProperty(value = "租户ID", notes = "租户ID")
    @JsonView(View.class)
    protected long tenantId;

    /**
     * 主配置ID.
     */
    @ApiModelProperty(value = "主配置ID", notes = "主配置ID")
    @JsonView(View.class)
    protected long ssoId;


    /**
     * userInfoUrl.
     */
    @ApiModelProperty(value = "userInfoUrl", notes = "userInfoUrl")
    @JsonView(View.class)
    protected String userInfoUrl;


    /**
     * 更新用户Id.
     */
    @ApiModelProperty(value = "更新用户Id", notes = "更新用户Id")
    @JsonView(View.class)
    protected String updateUserId;

    /**
     * 更新用户名称.
     */
    @ApiModelProperty(value = "更新用户名称", notes = "更新用户名称")
    @JsonView(View.class)
    protected String updateUserName;

    /**
     * 更新时间.
     */
    @ApiModelProperty(value = "更新时间", notes = "更新时间")
    @JsonView(View.class)
    protected Date updateTime;

    /**
     * 创建用户ID.
     */
    @ApiModelProperty(value = "创建用户ID", notes = "创建用户ID")
    @JsonView(View.class)
    protected String createUserId;

    /**
     * 创建时间.
     */
    @ApiModelProperty(value = "创建时间", notes = "创建时间")
    @JsonView(View.class)
    protected Date createTime;

}
