package com.xforceplus.domain.sso;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "SSO配置主数据")
@Getter
@Setter
public class SsoConfDto<S extends SsoSamlDto, A extends SsoAuth2Dto, J extends SsoJwtDto, C extends SsoCodeDto> implements Serializable {

    /**
     * ID.
     */
    @ApiModelProperty(value = "ID", notes = "主键")
    @JsonView(View.class)
    protected long id;

    /**
     * 租户ID.
     */
    @ApiModelProperty(value = "租户ID", notes = "租户ID")
    @JsonView(View.class)
    protected long tenantId;

    /**
     * 租户Code.
     */
    @ApiModelProperty(value = "租户Code", notes = "租户Code")
    @JsonView(View.class)
    protected String tenantCode;

    /**
     * 协议类型.
     */
    @ApiModelProperty(value = "协议类型", notes = "协议类型")
    @JsonView(View.class)
    protected String protocolType;

    /**
     * 状态.
     */
    @ApiModelProperty(value = "状态", notes = "状态")
    @JsonView(View.class)
    protected boolean status;

    /**
     * ssoUrl.
     */
    @ApiModelProperty(value = "sso url", notes = "sso url")
    @JsonView(View.class)
    protected String ssoUrl;

    /**
     * 更新用户Id.
     */
    @ApiModelProperty(value = "更新用户Id", notes = "更新用户Id")
    @JsonView(View.class)
    protected String updateUserId;

    /**
     * 更新用户名称.
     */
    @ApiModelProperty(value = "更新用户名称", notes = "更新用户名称")
    @JsonView(View.class)
    protected String updateUserName;

    /**
     * 更新时间.
     */
    @ApiModelProperty(value = "更新时间", notes = "更新时间")
    @JsonView(View.class)
    protected Date updateTime;

    /**
     * 创建用户ID.
     */
    @ApiModelProperty(value = "创建用户ID", notes = "创建用户ID")
    @JsonView(View.class)
    protected String createUserId;

    /**
     * 创建时间.
     */
    @ApiModelProperty(value = "创建时间", notes = "创建时间")
    @JsonView(View.class)
    protected Date createTime;

    /**
     * saml 协议附加信息。
     */
    protected S ssoSaml;

    /**
     * auth2 协议附加信息。
     */
    protected A ssoAuth2;

    /**
     * jwt 协议附加信息。
     */
    protected J ssoJwt;

    /**
     * code 协议附加信息。
     */
    protected C ssoCode;
}
