package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.tenant.view.SysRole;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;
import java.util.Set;

/**
 * 权限角色
 *
 * @author geewit
 */
@SuppressWarnings("all")
@Setter
@Getter
public class RoleDto extends TokenRole implements IOperator {

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("角色标签集合")
    protected Set<Tag> tags;

    @JsonView(SysRole.class)
    @ApiModelProperty("租户集合")
    protected Set<Long> tenantIds;

    @JsonView(SysRole.class)
    @ApiModelProperty("功能集id集合")
    protected Set<Long> resourcesetIds;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("功能集集合")
    protected Set<ResourcesetDto> resourcesets;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("自定义功能集下资源码集合")
    protected Set<ResourceDto> resources;

    @ApiModelProperty(value = "来源角色id")
    @JsonView(View.class)
    protected Long fromRoleId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleDto role = (RoleDto) o;
        return id.equals(role.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", tags=" + tags +
                '}';
    }
}
