package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/***
 * @author geewit
 */
@SuppressWarnings("all")
@ApiModel(value = "租户")
@Setter
@Getter
public class TenantDto implements IOperator {
    @JsonView({View.class})
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户描述")
    protected String tenantDesc;

    @JsonView({View.class})
    @ApiModelProperty(value = "入驻来源")
    protected String settledOrigin;

    @JsonView({View.class})
    protected String operateReason;

    @ApiModelProperty(value = "租户图标")
    @JsonView({View.class})
    protected String tenantLogo;

    @JsonView({View.class})
    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView({View.class})
    protected Integer companyCount;

    @JsonView(View.class)
    @ApiModelProperty("租户扩展")
    protected List<TenantExtensionDto> extensions;

    @JsonView(View.class)
    @ApiModelProperty("租户管理员")
    protected TenantManagerDto tenantManager;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantDto)) {
            return false;
        }
        TenantDto that = (TenantDto) o;
        return this.tenantId.equals(that.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tenantId);
    }
}
