package com.xforceplus.domain.user;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;


/***
 * @author geewit
 */
@ApiModel(value = "用户")
@Setter
public class UserDto<O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> extends AuthorizedUser<O, R> implements IOperator {
    @ApiModelProperty(value = "用户编码", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userNumber;

    @ApiModelProperty(value = "联系电话")
    @JsonView(View.class)
    protected String userPhone;

    @ApiModelProperty(value = "性别")
    @JsonView(View.class)
    protected Integer userSex;

    @JsonView(View.class)
    protected String userEmailAddr;

    @JsonView(View.class)
    protected String userIdCard;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView(View.class)
    protected Date userPeriodTime;

    @JsonView(View.class)
    protected String userWorkTel;

    @JsonView(View.class)
    protected Integer activeStatus;

    @JsonView(View.class)
    protected Integer userType;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @JsonView(View.class)
    protected String contactAddr;

    @ApiModelProperty("业务扩展属性")
    @JsonView(View.class)
    protected String businessExtensionAttribute;
    @ApiModelProperty(value = "发票类型", notes = "c：普票；s：专票；cs：专票和普票 ce：普电票")
    @JsonView(View.class)
    protected String invoiceType;
    @ApiModelProperty(value = "打印设备", notes = "多个打印设备值用','隔开")
    @JsonView(View.class)
    protected String printingEquipment;
    @ApiModelProperty(value = "开票终端", notes = "多个开票终端用','分隔开")
    @JsonView(View.class)
    protected String ticketOpeningTerminal;

    @ApiModelProperty("账号信息")
    protected A account;

    @ApiModelProperty("过滤组织parentIds集合")
    protected Set<String> filterParentIdSet;

    public String getUserNumber() {
        return userNumber;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public String getUserIdCard() {
        return userIdCard;
    }

    public Date getUserPeriodTime() {
        return userPeriodTime;
    }

    public String getUserWorkTel() {
        return userWorkTel;
    }

    public Integer getActiveStatus() {
        return activeStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public String getContactAddr() {
        return contactAddr;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    public String getBusinessExtensionAttribute() {
        return businessExtensionAttribute;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public String getPrintingEquipment() {
        return printingEquipment;
    }

    public String getTicketOpeningTerminal() {
        return ticketOpeningTerminal;
    }

    public Integer getUserType() {
        return userType;
    }

    @SuppressWarnings("all")
    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getOrgs() {
        return orgs;
    }

    @Override
    @JsonView(UserView.UserInfo.class)
    public Set<O> getCurrentOrgs() {
        return currentOrgs;
    }

    @JsonView(UserView.UserInfo.class)
    public A getAccount() {
        return account;
    }
}
