/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.validation.validator;

import com.xforceplus.validation.constraints.StringInclude;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringIncludeValidator
implements ConstraintValidator<StringInclude, String> {
    private static final Logger log = LoggerFactory.getLogger(StringIncludeValidator.class);
    private boolean required;
    private List<String> strList = Collections.emptyList();

    public void initialize(StringInclude stringInclude) {
        log.info("stringInclude:{}", (Object)stringInclude.toString());
        this.required = stringInclude.required();
        this.strList = Arrays.asList(stringInclude.range());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return !this.required;
        }
        return this.strList.contains(value);
    }
}

