/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.redis.lock.interceptor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.redis.lock.RedisLock;
import com.xforceplus.redis.lock.manager.RedisManager;
import io.geewit.web.utils.JsonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
@ConditionalOnBean(value={RedisTemplate.class})
public class RedisLockInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockInterceptor.class);
    private static final String PROPERTY_KEY = "key";
    private static final Integer MAX_RETRY_COUNT = 10;
    private static final String LOCK_PRE_FIX = "lockPreFix";
    private static final String TIME_OUT = "timeOut";
    @Autowired
    private RedisManager redisManager;

    public static Object getFieldValueByObject(Object object, String targetFieldName) throws Exception {
        Field[] fields;
        Class<?> objClass = object.getClass();
        for (Field field : fields = objClass.getDeclaredFields()) {
            String currentFieldName = "";
            boolean hasJsonProperty = field.isAnnotationPresent(JsonProperty.class);
            currentFieldName = hasJsonProperty ? field.getAnnotation(JsonProperty.class).value() : field.getName();
            if (!currentFieldName.equals(targetFieldName)) continue;
            return field.get(object);
        }
        return null;
    }

    @Pointcut(value="@annotation( com.xforceplus.redis.lock.RedisLock)")
    public void redisLockAspect() {
    }

    @Around(value="redisLockAspect()")
    public Object lockAroundAction(ProceedingJoinPoint proceeding) throws Throwable {
        Object[] args = proceeding.getArgs();
        Map<String, Object> getLockResult = this.getLock(proceeding, 0, System.currentTimeMillis());
        logger.info("\u83b7\u53d6\u9501\u7684\u7ed3\u679c\u4e3a{},{}", getLockResult.get("code"), getLockResult.get("msg"));
        logger.info("\u5f00\u59cb\u5904\u7406");
        Object reps = proceeding.proceed();
        logger.info("\u7ed3\u679c\u4e3a{}", (Object)JsonUtils.toJson((Object)reps));
        return reps;
    }

    private Map<String, Object> getLock(ProceedingJoinPoint proceeding, int count, long currentTime) {
        Map<String, Object> annotationArgs = this.getAnnotationArgs(proceeding);
        String lockPrefix = (String)annotationArgs.get(LOCK_PRE_FIX);
        String property = (String)annotationArgs.get(PROPERTY_KEY);
        long expire = (Long)annotationArgs.get(TIME_OUT);
        String key = this.getFirstArg(proceeding, property);
        if (StringUtils.isEmpty((Object)lockPrefix) || StringUtils.isEmpty((Object)key)) {
            return this.argErrResult("\u9501\u524d\u7f00\u6216\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String lockName = lockPrefix + "_" + key;
        logger.info("\u83b7\u5f97\u6240\u5f97key\u4e3a{}", (Object)lockName);
        if (this.redisManager.lock(lockPrefix, key, expire)) {
            return this.buildSuccessResult();
        }
        if (System.currentTimeMillis() - currentTime > 5000L && (this.redisManager.ttl(lockName) < 0L || System.currentTimeMillis() - currentTime > expire)) {
            this.redisManager.delete(lockName);
            if (count < MAX_RETRY_COUNT) {
                return this.getLock(proceeding, count++, currentTime);
            }
        }
        return this.buildGetLockErrorResult("\u8bf7\u91cd\u8bd5\uff01\uff01\uff01");
    }

    private Map<String, Object> getAnnotationArgs(ProceedingJoinPoint proceeding) {
        Class<?> target = proceeding.getTarget().getClass();
        Method[] methods = target.getMethods();
        String methodName = proceeding.getSignature().getName();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            HashMap<String, Object> result = new HashMap<String, Object>();
            RedisLock redisLock = method.getAnnotation(RedisLock.class);
            result.put(LOCK_PRE_FIX, redisLock.lockPrefix());
            result.put(TIME_OUT, redisLock.timeUnit().toSeconds(redisLock.timeOut()));
            result.put(PROPERTY_KEY, redisLock.key());
            return result;
        }
        return new HashMap<String, Object>(0);
    }

    public String getFirstArg(ProceedingJoinPoint proceeding, String property) {
        Object[] args = proceeding.getArgs();
        if (args != null && args.length > 0) {
            if (StringUtils.hasText((String)property)) {
                try {
                    Object jsonObject = RedisLockInterceptor.getFieldValueByObject(args[0], property);
                    if (null == jsonObject) {
                        logger.error("\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027\u503c\u5931\u8d25{},{}", (Object)JsonUtils.toJson((Object)args[0]), (Object)property);
                        return proceeding.getClass().getName();
                    }
                    return jsonObject.toString();
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027\u503c\u5931\u8d25{},{}", (Object)JsonUtils.toJson((Object)args[0]), (Object)property);
                    logger.error("\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027\u503c\u5931\u8d25\u539f\u56e0:" + e.getMessage(), (Throwable)e);
                    return proceeding.getClass().getName();
                }
            }
            for (Object object : args) {
                String type = object.getClass().getName();
                if (!"java.lang.String".equals(type)) continue;
                return (String)object;
            }
        }
        return proceeding.getClass().getName();
    }

    public Map<String, Object> argErrResult(String mes) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("code", "9");
        result.put("msg", mes);
        return result;
    }

    public Map<String, Object> buildGetLockErrorResult(String mes) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("code", "9");
        result.put("msg", mes);
        return result;
    }

    public Map<String, Object> buildSuccessResult() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("code", "1");
        result.put("msg", "\u5904\u7406\u6210\u529f");
        return result;
    }
}

