package com.xforceplus.redis.lock.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * @author libaozhong
 */
@ConditionalOnBean(RedisConfiguration.class)
@Configuration
/***
 * 开启注解
 */
@EnableCaching
@ConditionalOnMissingBean(RedisTemplate.class)
public class RedisLockConfig {
}
