/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.redis.lock.manager;

import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnBean(value={RedisTemplate.class})
public class RedisManager {
    @Autowired
    RedisTemplate<String, String> redisTemplate;

    public boolean lock(String lockPrefix, String key, Long lockExpire) {
        String lock = lockPrefix + key;
        return (Boolean)this.redisTemplate.execute(connection -> {
            long expireTime;
            long expireAt = System.currentTimeMillis() + lockExpire + 1L;
            Boolean acquire = connection.setNX(lock.getBytes(), String.valueOf(expireAt).getBytes());
            if (acquire.booleanValue()) {
                return true;
            }
            byte[] value = connection.get(lock.getBytes());
            if (Objects.nonNull(value) && value.length > 0 && (expireTime = Long.parseLong(new String(value))) < System.currentTimeMillis()) {
                byte[] oldValue = connection.getSet(lock.getBytes(), String.valueOf(System.currentTimeMillis() + lockExpire + 1L).getBytes());
                return Long.parseLong(new String(oldValue)) < System.currentTimeMillis();
            }
            return false;
        });
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Long ttl(String lockName) {
        return this.redisTemplate.getExpire((Object)lockName);
    }
}

