/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.advice;

import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.IpUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class XforceRequestBodyAdviceAdapter
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(XforceRequestBodyAdviceAdapter.class);
    @Autowired
    HttpServletRequest httpServletRequest;
    private static final String PASSWORD = "password";

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return super.beforeBodyRead(inputMessage, parameter, targetType, converterType);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        try {
            this.logRequest(this.httpServletRequest, body);
        }
        catch (Exception exception) {
            log.error("error while logging request info:{}", (Object)exception.getMessage());
        }
        return super.afterBodyRead(body, inputMessage, parameter, targetType, converterType);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return super.handleEmptyBody(body, inputMessage, parameter, targetType, converterType);
    }

    private void logRequest(HttpServletRequest request, Object body) {
        IAuthorizedUser authorizedUser;
        String remoteIp = IpUtils.getIp(request);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("REQUEST INFO:");
        stringBuilder.append("path = [").append(request.getRequestURI()).append("(").append(request.getMethod()).append(")").append("];");
        stringBuilder.append("remoteIp=[").append(remoteIp).append("]").append(";");
        String queryString = request.getQueryString();
        if (queryString != null) {
            queryString = queryString.replace("&", ";");
            queryString = this.filterSensitiveLog(queryString);
            stringBuilder.append("queryString = [").append(queryString).append("];");
        }
        if ((authorizedUser = UserInfoHolder.get()) != null) {
            stringBuilder.append("userId = [").append(authorizedUser.getId()).append("];").append("tenantId = [").append(authorizedUser.getTenantId()).append("];");
        } else {
            String clientId = ClientInfoHolder.get();
            if (clientId != null) {
                stringBuilder.append("clientId=[").append(clientId).append("];");
            }
        }
        if (body != null) {
            stringBuilder.append("body = [").append(body).append("];");
        }
        log.info(stringBuilder.toString());
    }

    private String filterSensitiveLog(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if (!source.contains(PASSWORD)) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        String[] elements = source.split(";");
        Arrays.stream(elements).forEach(item -> {
            String[] kv = item.split("=");
            if (!kv[0].equals(PASSWORD)) {
                sb.append((String)item).append(";");
            } else {
                sb.append("pwdlength").append("=");
                if (kv.length < 2) {
                    sb.append(0).append(";");
                } else {
                    if (StringUtils.isNotBlank((CharSequence)kv[1])) {
                        sb.append(kv[1].length());
                    } else {
                        sb.append(0);
                    }
                    sb.append(";");
                }
            }
        });
        return sb.toString();
    }
}

