/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.account.AccountApi;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.account.service.AccountPrivacyService;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.account.AccountExceptionDto;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.dto.user.AccountUserDTO;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5e10\u53f7\u76f8\u5173\u63a5\u53e3", description="\u5e10\u53f7\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class AccountController
implements AccountApi,
com.xforceplus.api.current.account.AccountApi {
    private static final Logger logger = LoggerFactory.getLogger(AccountController.class);
    private final AccountService accountService;
    private final UserService userService;
    private final AccountPrivacyService accountPrivacyService;

    public AccountController(AccountService accountService, UserService userService, AccountPrivacyService accountPrivacy) {
        this.accountService = accountService;
        this.userService = userService;
        this.accountPrivacyService = accountPrivacy;
    }

    @ApiOperation(value="\u767b\u5f55\u5e76\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    public ResponseEntity<User> login(AccountModel.Request.Login login, int extraInfoDimension) {
        User result = this.userService.login(login, extraInfoDimension);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={View.List.class})
    @ApiOperation(value="\u83b7\u53d6account\u7684User\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6account\u7684User\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/accounts/{accountId}/users"}, method={RequestMethod.GET})
    public ResponseEntity<List<AccountUserDTO>> accountUserList(@ApiParam(value="accountId", required=true) @PathVariable(value="accountId") long accountId) {
        return ResponseEntity.ok(this.accountService.accountUserList(accountId));
    }

    @ApiIgnore
    @JsonView(value={View.List.class})
    @ApiOperation(value="\u83b7\u53d6\u5e10\u53f7\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u5e10\u53f7\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u5e10\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"/api/global/accounts/query"}, method={RequestMethod.GET})
    public Page<Account> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<Account> page = this.accountService.page((Specification<Account>)specification, pageable);
        return page;
    }

    @JsonView(value={View.List.class})
    @ApiOperation(value="\u83b7\u53d6\u5e10\u53f7\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u5e10\u53f7\u5206\u9875")
    public ResponseEntity<Page<Account>> page(@ApiParam(value="request") AccountModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<Account> result = this.accountService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(authentication=false)
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u540d\u83b7\u53d6\u5e10\u53f7\u8be6\u60c5", notes="\u901a\u8fc7\u7528\u6237\u540d\u83b7\u53d6\u5e10\u53f7\u8be6\u60c5")
    public ResponseEntity<Account> queryByUsername(@PathVariable(value="username") String username) {
        Account result = this.accountService.findOneByUsername(username);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={View.List.class})
    @ApiOperation(value="\u65b0\u589e\u5e10\u53f7")
    public ResponseEntity<Account> create(@ApiParam(value="account", required=true) AccountModel.Request.Create model) {
        Account result = this.accountService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<String> register(@Valid AccountModel.Request.Regist regist) {
        UserModel.Request.Create userModel = new UserModel.Request.Create();
        AccountModel.Request.Create accountModel = new AccountModel.Request.Create();
        BeanUtils.copyProperties((Object)regist, (Object)accountModel);
        userModel.setAccount(accountModel);
        if (!StringUtils.isEmpty((Object)regist.getEmail())) {
            userModel.setUserEmailAddr(regist.getEmail());
        }
        if (!StringUtils.isEmpty((Object)regist.getTelPhone())) {
            userModel.setUserPhone(regist.getTelPhone());
        }
        userModel.setStatus(Integer.valueOf(1));
        accountModel.setType(AccountType.PHONE_EMAIL);
        UserModel.Request.SaveUserOutput userOutput = this.userService.register(userModel, regist.getOpenId());
        if (userOutput != null) {
            return ResponseEntity.ok((Object)"\u6ce8\u518c\u6210\u529f");
        }
        return ResponseEntity.fail((String)"-1", (String)"\u6ce8\u518c\u5931\u8d25");
    }

    @JsonView(value={View.List.class})
    public <T extends AccountDto> ResponseEntity<List<T>> createBatch(@RequestBody List<AccountModel.Request.Create> models) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (AccountModel.Request.Create create : models) {
            try {
                Account result = this.accountService.saveOriginPassword(create);
                resultList.add(result);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                resultList.add(new AccountExceptionDto(e.getMessage()));
            }
        }
        return ResponseEntity.ok(resultList);
    }

    @JsonView(value={View.List.class})
    @ApiOperation(value="\u4fee\u6539\u5e10\u53f7")
    public ResponseEntity<Account> update(@ApiParam(value="accountId", required=true) long accountId, @ApiParam(value="account", required=true) AccountModel.Request.Update model) {
        Account result = this.accountService.update(accountId, model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u5e10\u53f7\u72b6\u6001")
    public ResponseEntity<String> updateStatus(@ApiParam(value="accountId", required=true) long accountId, @ApiParam(value="status", required=true) int status) {
        this.accountService.updateStatus(accountId, status);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u8d26\u53f7\u9501\u5b9a")
    public ResponseEntity<String> accountLock(@ApiParam(value="accountId", required=true) long accountId) {
        this.accountService.updateStatus(accountId, 0);
        return ResponseEntity.ok((Object)"\u9501\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u8d26\u53f7\u89e3\u9501")
    public ResponseEntity<String> accountUnlock(@ApiParam(value="accountId", required=true) long accountId) {
        this.accountService.updateStatus(accountId, 1);
        return ResponseEntity.ok((Object)"\u89e3\u9501\u6210\u529f");
    }

    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5e10\u53f7\u4fe1\u606f")
    public ResponseEntity<Account> info(long accountId) {
        Account result = this.accountService.findById(accountId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(authentication=false)
    @ApiOperation(value="\u6839\u636eusername\u66f4\u6539\u8d26\u6237\u5bc6\u7801")
    public ResponseEntity<String> updatePassword(AccountModel.Request.ChangePassword request) {
        this.accountService.resetPassword(request);
        return ResponseEntity.ok((Object)"\u66f4\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636eaccountId\u66f4\u6539\u8d26\u6237\u5bc6\u7801")
    public ResponseEntity<String> updatePasswordByAccountId(@Valid @Min(value=1L) @Valid @Min(value=1L) long accountId, @Valid AccountModel.Request.ChangePasswordById request) {
        this.accountService.changePassword(accountId, request.getPassword());
        return ResponseEntity.ok((Object)"\u66f4\u6539\u6210\u529f");
    }

    public ResponseEntity<String> checkPassword(@Valid AccountModel.Request.CheckPassword request) {
        Long accountId = UserInfoHolder.currentUser().getAccountId();
        this.accountService.checkPasswordByAccountId(accountId, request.getPassword());
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> sendChangePhoneCode(String phone) {
        String msgId = this.accountService.sendChangePhoneCode(phone);
        return ResponseEntity.ok((Object)msgId);
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> sendChangeEmailCode(String email) {
        String msgId = this.accountService.sendChangeEmailCode(email);
        return ResponseEntity.ok((Object)msgId);
    }

    public ResponseEntity<String> changePhone(AccountModel.Request.ChangePhone request) {
        this.accountService.changePhone(request);
        return ResponseEntity.ok();
    }

    public ResponseEntity<String> changeEmail(AccountModel.Request.ChangeEmail request) {
        this.accountService.changeEmail(request);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> bindPhone(@Valid AccountModel.Request.BindPhone request) {
        this.accountService.bindPhone(request);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> bindEmail(@Valid AccountModel.Request.BindEmail request) {
        this.accountService.bindEmail(request);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> sendValidCode(String username) {
        String msgId = this.accountService.sendValidCode(username);
        return ResponseEntity.ok((Object)msgId);
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> updatePwd(@Valid AccountModel.ChangePwd request) {
        this.accountService.updatePwd(request);
        return ResponseEntity.ok();
    }

    @JsonView(value={View.Info.class})
    public ResponseEntity<Account> currentQueryByUsername(String username) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        String tenantCode = authorizedUser.getTenantCode();
        Account result = this.accountService.findOneByUsername(tenantCode, username);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> currentUpdatePassword(@Valid AccountModel.Request.ChangePassword request) {
        this.accountService.resetPassword(request);
        return ResponseEntity.ok((Object)"\u66f4\u6539\u6210\u529f");
    }

    public ResponseEntity<String> unBindPhone(@Valid AccountModel.Request.UnBindPhone request) {
        this.accountService.unBindPhone(request);
        return ResponseEntity.ok();
    }

    public ResponseEntity<String> unBindEmail(AccountModel.Request.UnBindEmail request) {
        this.accountService.unBindEmail(request);
        return ResponseEntity.ok();
    }

    public ResponseEntity<User> changeTenant(long accountId, long tenantId) {
        User user = this.userService.changeTenantByAccount(accountId, tenantId);
        return ResponseEntity.ok((Object)user);
    }

    public ResponseEntity<String> currentUserUpdatePassword(AccountModel.Request.ChangeCurrentPassword request) {
        this.accountService.resetCurrentUserPassword(request);
        return ResponseEntity.ok();
    }

    @JsonView(value={View.Info.class})
    public ResponseEntity<Account> currentCheckByUsername(String username) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)username)) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u683c\u5f0f\u9519\u8bef");
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        String tenantCode = authorizedUser.getTenantCode();
        Account result = this.accountService.findOneByUsernameV2(tenantCode, username);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity updateLastLoginTime(long accountId) {
        this.accountService.updateLastLoginTime(accountId);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u68c0\u67e5\u5f53\u524d\u8d26\u53f7\u662f\u5426\u786e\u8ba4\u8fc7\u8be5\u7f51\u7ad9\u7684\u9690\u79c1\u534f\u8bae")
    public ResponseEntity<Boolean> checkCurrentUserPrivacy(Long accountId, String webSite, String version) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        AccountModel.AccountPrivacyInfo request = new AccountModel.AccountPrivacyInfo();
        request.setAccountId(accountId);
        request.setWebSite(StringUtils.trimWhitespace((String)webSite));
        if (!StringUtils.isEmpty((Object)version)) {
            request.setVersion(StringUtils.trimWhitespace((String)version));
        }
        Boolean checkResult = this.accountPrivacyService.checkAccountPrivacy(request);
        return ResponseEntity.ok((Object)checkResult);
    }

    @ApiOperation(value="\u6dfb\u52a0\u9690\u79c1\u534f\u8bae")
    public ResponseEntity addCurrentUserPrivacy(@Valid AccountModel.AccountPrivacyInfo request) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.getAccountId().equals(request.getAccountId())) {
            throw new IllegalArgumentException("\u8d26\u53f7\u4fe1\u606f\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d");
        }
        this.accountPrivacyService.addAccountPrivacy(request);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5e10\u53f7\u52a0\u5bc6\u5bc6\u7801")
    public ResponseEntity<String> getEncryptPassword(Long accountId) {
        return ResponseEntity.ok((Object)this.accountService.getEncryptedPwd(accountId));
    }
}

