/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.AccountPlatformRelModel;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.AccountPlatformRelDao;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.entity.User;
import com.xforceplus.query.AccountPlatformRelQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountPlatformRelService {
    private static final Logger logger = LoggerFactory.getLogger(AccountPlatformRelService.class);
    private final AccountPlatformRelDao accountPlatformRelDao;
    @Resource
    private AccountDao accountDao;
    @Resource
    private UserService userService;

    public AccountPlatformRelService(AccountPlatformRelDao accountPlatformRelDao) {
        this.accountPlatformRelDao = accountPlatformRelDao;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public AccountPlatformRel save(AccountPlatformRelModel.Request.Save model) {
        Long userId;
        Optional accountOptional = this.accountDao.findById((Object)model.getAccountId());
        if (!accountOptional.isPresent()) {
            throw new IllegalArgumentException("\u4f20\u5165accountId\u975e\u6cd5:" + model.getAccountId());
        }
        try {
            userId = Long.parseLong(model.getUserId());
        }
        catch (NumberFormatException e) {
            userId = -1L;
        }
        Optional<User> user = this.userService.findUserById(userId);
        if (!user.isPresent()) {
            throw new IllegalArgumentException("\u4f20\u5165userId\u975e\u6cd5:" + model.getUserId());
        }
        AccountPlatformRel accountPlatformRel = this.getAccountPlatformRel(model.getPlatformType(), model.getPlatformId());
        if (accountPlatformRel == null) {
            accountPlatformRel = new AccountPlatformRel();
            BeanUtils.copyProperties((Object)model, (Object)accountPlatformRel);
            accountPlatformRel.setStatus(Integer.valueOf(1));
            accountPlatformRel.setEnableTime(new Date());
            accountPlatformRel.setCreateTime(new Date());
            accountPlatformRel.setUpdateTime(new Date());
        } else {
            accountPlatformRel.setAccountId(model.getAccountId());
            accountPlatformRel.setUserId(model.getUserId());
            accountPlatformRel.setStatus(Integer.valueOf(1));
            accountPlatformRel.setEnableTime(new Date());
            accountPlatformRel.setUpdateTime(new Date());
        }
        return (AccountPlatformRel)this.accountPlatformRelDao.saveAndFlush((Object)accountPlatformRel);
    }

    public AccountPlatformRel getInfoByPlatformId(int platformType, String platformId) {
        AccountPlatformRel accountPlatformRel = this.getAccountPlatformRel(platformType, platformId);
        if (accountPlatformRel == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53");
        }
        return accountPlatformRel;
    }

    public AccountPlatformRel getAccountPlatformRel(final int platformType, final String platformId) {
        if (platformType <= 0 || StringUtils.isBlank((CharSequence)platformId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e(platformType)");
        }
        Optional optional = this.accountPlatformRelDao.findOne((Specification)new Specification<AccountPlatformRel>(){

            public Predicate toPredicate(Root<AccountPlatformRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("platformType"), (Object)platformType));
                predicates.add(builder.equal((Expression)root.get("platformId"), (Object)platformId));
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        return optional.orElse(null);
    }

    public List<AccountPlatformRel> list(final Long userId, final Integer platformType) {
        List list = this.accountPlatformRelDao.findAll((Specification)new Specification<AccountPlatformRel>(){

            public Predicate toPredicate(Root<AccountPlatformRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("userId"), (Object)userId));
                predicates.add(builder.equal((Expression)root.get("status"), (Object)1));
                if (platformType != null) {
                    predicates.add(builder.equal((Expression)root.get("platformType"), (Object)platformType));
                }
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        return list;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateState(AccountPlatformRelModel.Request.ChangeState changeState) {
        Long userId;
        try {
            userId = Long.parseLong(changeState.getUserId());
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", id: " + changeState.getUserId();
            logger.warn(message);
            userId = null;
        }
        if (userId == null) {
            String message = "userId\u4e0d\u80fd\u4e3a\u7a7a";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Optional<User> optionalUser = this.userService.findUserById(userId);
        if (!optionalUser.isPresent()) {
            throw new IllegalArgumentException("userId\u6709\u8bef!");
        }
        AccountPlatformRelModel.Request.Query query = new AccountPlatformRelModel.Request.Query();
        query.setUserId(changeState.getUserId());
        query.setPlatformType(changeState.getPlatformType());
        Specification specification = AccountPlatformRelQueryHelper.querySpecification((AccountPlatformRelModel.Request.Query)query);
        List list = this.accountPlatformRelDao.findAll(specification);
        if (!list.isEmpty()) {
            list.stream().forEach(rel -> {
                rel.setStatus(changeState.getStatus());
                rel.setUpdateTime(new Date());
                this.accountPlatformRelDao.saveAndFlush(rel);
            });
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public AccountPlatformRel saveAccountPlatformRel(AccountPlatformRel accountPlatformRel) {
        return (AccountPlatformRel)this.accountPlatformRelDao.saveAndFlush((Object)accountPlatformRel);
    }

    public Page<AccountPlatformRel> page(AccountPlatformRelModel.Request.Query query, Pageable pageable) {
        Specification specification = AccountPlatformRelQueryHelper.querySpecification((AccountPlatformRelModel.Request.Query)query);
        return this.accountPlatformRelDao.findAll(specification, pageable);
    }
}

