/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.app.service;

import com.xforceplus.api.model.AppModel;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.UserAppDao;
import com.xforceplus.domain.app.AppDto;
import com.xforceplus.entity.App;
import com.xforceplus.query.AppQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppService {
    private static final Logger logger = LoggerFactory.getLogger(AppService.class);
    private final AppDao appDao;
    private final UserAppDao userAppDao;

    public AppService(AppDao appDao, UserAppDao userAppDao) {
        this.appDao = appDao;
        this.userAppDao = userAppDao;
    }

    public App findOne(AppModel.Request.Query query) {
        Specification specification = AppQueryHelper.querySpecification((AppModel.Request.Query)query);
        return (App)this.appDao.findOne(specification).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    public <T extends AppDto> Page<App> page(AppModel.Request.Query query, Pageable pageable) {
        Specification specification = AppQueryHelper.querySpecification((AppModel.Request.Query)query);
        return this.appDao.findAll(specification, pageable);
    }

    public Page<App> page(Specification<App> specification, Pageable pageable) {
        return this.appDao.findAll(specification, pageable);
    }

    public List<App> list() {
        AppModel.Request.Query query = new AppModel.Request.Query();
        Specification specification = AppQueryHelper.querySpecification((AppModel.Request.Query)query);
        return this.appDao.findAll(specification, Sort.by((String[])new String[]{"appId"}));
    }

    public List<App> list(Specification<App> specification, Sort sort) {
        return this.appDao.findAll(specification, sort);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public App create(AppModel.Request.Create model) {
        if (this.appDao.existsById((Object)model.getAppId())) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u8be5id");
        }
        App entity = new App();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity = (App)this.appDao.saveAndFlush((Object)entity);
        return entity;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public App update(long appId, AppModel.Request.Save model) {
        App existEntity = this.findById(appId);
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (App)this.appDao.saveAndFlush((Object)existEntity);
        return existEntity;
    }

    public App findById(long appId) {
        return (App)this.appDao.findById((Object)appId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteById(long appId) {
        App app = this.findById(appId);
        this.appDao.deleteById(app.getAppId());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public App updateStatus(long appId, int status) {
        App existEntity = this.findById(appId);
        existEntity.setStatus(Integer.valueOf(status));
        existEntity = (App)this.appDao.saveAndFlush((Object)existEntity);
        return existEntity;
    }

    public Set<Long> userApps(long userId) {
        Set appIds = this.userAppDao.findAppIdByUserId(userId);
        return appIds;
    }

    public Set<Long> currentAppIds() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Set appIds = this.userAppDao.findAppIdByUserId(authorizedUser.getId().longValue());
        return appIds;
    }
}

