/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.cache.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.business.cache.service.CacheService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.swagger.annotations.Api;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7f13\u5b58\u76f8\u5173\u63a5\u53e3", description="\u7f13\u5b58\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class CacheController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Resource
    private CacheService cacheService;

    @AuthorizedDefinition(resources={"xforce:admin:ops"})
    @ResponseBody
    @RequestMapping(name="\u6e05\u7a7a\u6240\u6709\u7f13\u5b58", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/cache/all/clear"}, method={RequestMethod.GET})
    public ResponseEntity<String> clearAll() {
        return ResponseEntity.ok((Object)"\u6e05\u7a7a\u6240\u6709\u7f13\u5b58\u5b8c\u6210");
    }

    @AuthorizedDefinition(resources={"xforce:admin:ops"})
    @ResponseBody
    @RequestMapping(name="\u6e05\u7a7a\u6307\u5b9a\u7f13\u5b58", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/cache/{cacheName}/clear"}, method={RequestMethod.GET})
    public ResponseEntity<String> clear(@PathVariable(value="cacheName") String cacheName) {
        return ResponseEntity.ok((Object)("\u6e05\u7a7a\u6307\u5b9a\u7f13\u5b58(" + cacheName + ")\u5b8c\u6210"));
    }

    @ApiIgnore
    @ResponseBody
    @RequestMapping(name="redis\u5220\u9664\u6307\u5b9akey", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/cache/del"}, method={RequestMethod.GET})
    public ResponseEntity<String> del(@RequestParam String key) {
        Boolean result = this.cacheService.del(key);
        return ResponseEntity.ok((Object)result.toString());
    }
}

