/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.client.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.client.ClientApi;
import com.xforceplus.api.model.ClientModel;
import com.xforceplus.business.client.service.ClientSecretService;
import com.xforceplus.domain.client.ClientDto;
import com.xforceplus.entity.Client;
import io.geewit.core.utils.reflection.BeanUtils;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u516c\u53f8\u76f8\u5173\u63a5\u53e3", tags={"client"})
@Controller
public class ClientController
implements ClientApi {
    private final ClientSecretService clientService;

    public ClientController(ClientSecretService clientService) {
        this.clientService = clientService;
    }

    @ResponseBody
    @RequestMapping(name="client\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients"}, method={RequestMethod.GET})
    public ResponseEntity<Page<Client>> page(@SpringQueryMap ClientModel.Request.Query query, Pageable pageable) {
        Page<Client> result = this.clientService.findByQuery(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ResponseBody
    @RequestMapping(name="client\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/list"}, method={RequestMethod.GET})
    @Deprecated
    public List<Client> list() {
        return this.clientService.findAll();
    }

    @ResponseBody
    @RequestMapping(name="client\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Client>> listV2() {
        return ResponseEntity.ok(this.clientService.findAll());
    }

    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"}, method={RequestMethod.GET})
    @Deprecated
    public ClientDto get(@PathVariable(value="clientId") String clientId) {
        return this.clientService.findById(clientId);
    }

    public ResponseEntity<Client> getV2(@PathVariable(value="clientId") String clientId) {
        return ResponseEntity.ok((Object)this.clientService.findById(clientId));
    }

    public ResponseEntity<Client> check(String clientId, String secret) {
        Client result = this.clientService.findByClientIdAndSecret(clientId, secret);
        return ResponseEntity.ok((Object)result);
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589eclient", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients"}, method={RequestMethod.POST})
    @Deprecated
    public Client create(@RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client);
        client = this.clientService.create(client);
        return client;
    }

    @ResponseBody
    @RequestMapping(name="\u65b0\u589eclient", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2"}, method={RequestMethod.POST})
    public ResponseEntity<Client> createV2(@RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client);
        client = this.clientService.create(client);
        return ResponseEntity.ok((Object)client);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"}, method={RequestMethod.PUT})
    @Deprecated
    public Client update(@PathVariable(value="clientId") String clientId, @RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client, (String[])new String[]{"clientId"});
        return this.clientService.update(clientId, client);
    }

    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2/{clientId}"}, method={RequestMethod.PUT})
    public ResponseEntity<Client> updateV2(@PathVariable(value="clientId") String clientId, @RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client, (String[])new String[]{"clientId"});
        return ResponseEntity.ok((Object)this.clientService.update(clientId, client));
    }

    @ResponseBody
    @RequestMapping(name="\u5220\u9664client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(@PathVariable(value="clientId") String clientId) {
        this.clientService.delete(clientId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }
}

