/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.company.CompanyTenantRelApi;
import com.xforceplus.api.model.CompanyTenantRelModel;
import com.xforceplus.business.company.service.CompanyTenantRelOperationProcess;
import com.xforceplus.business.company.service.CompanyTenantRelService;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

@Api(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u76f8\u5173\u63a5\u53e3", description="\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class CompanyTenantRelController
implements CompanyTenantRelApi {
    private static final Logger logger = LoggerFactory.getLogger(CompanyTenantRelController.class);
    private final CompanyTenantRelService companyTenantRelService;
    @Autowired
    private CompanyTenantRelOperationProcess operationProcess;

    public CompanyTenantRelController(CompanyTenantRelService companyTenantRelService) {
        this.companyTenantRelService = companyTenantRelService;
    }

    @ApiOperation(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u5206\u9875")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<Page<CompanyTenantRel>> page(CompanyTenantRelModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        TenantDto hostTenant = null;
        if (query.isThisIsHost()) {
            query.setTenantId(authorizedUser.getTenantId());
            hostTenant = new TenantDto();
            hostTenant.setTenantName(authorizedUser.getTenantName());
            hostTenant.setTenantCode(authorizedUser.getTenantCode());
        } else {
            query.setRelatedTenantId(authorizedUser.getTenantId());
        }
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<CompanyTenantRel> page = this.companyTenantRelService.page(query, currentPageable);
        for (CompanyTenantRel rel : page) {
            rel.fillCompany();
            rel.fillTenant();
            rel.fillRelatedEntity();
            if (!query.isThisIsHost()) {
                hostTenant = this.companyTenantRelService.findHostTenantByCompanyId(rel.getCompanyId());
            }
            rel.fillHostTenant(hostTenant);
        }
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u89e3\u9664\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:relationship:save"})
    public ResponseEntity<String> unrelate(long relId) {
        this.operationProcess.unrelateById(relId);
        return ResponseEntity.ok((Object)"\u6210\u529f\u89e3\u9664\u5173\u7cfb");
    }

    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u8be6\u60c5")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<CompanyTenantRelModel.Response.Info> info(long relId) {
        CompanyTenantRelModel.Response.Info info = this.companyTenantRelService.info(relId);
        return ResponseEntity.ok((Object)info);
    }

    @ApiOperation(value="\u66f4\u65b0\u516c\u53f8\u79df\u6237\u5173\u8054\u5173\u7cfb\u914d\u7f6e")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:policy:save"})
    public ResponseEntity<String> update(long relId, CompanyTenantRelModel.Request.Update model) {
        this.companyTenantRelService.update(relId, model);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }
}

